//pila.cpp
#include "pila.h"

Pila::Pila()  //costruttore a 0 arg. implementa PilaVuota
{ testa = NULL; }

Pila::~Pila() //distruttore
{ Cancella(testa); }

Pila::Pila(const Pila& p)  //costruttore di copia
{ testa = Copia(p.testa); }

Pila& Pila::operator=(const Pila& p)  //overloading assegnazione
{
  if (this != &p) {
    Cancella(testa);
    testa = Copia(p.testa);
  }
  return *this;
}

bool Pila::EstVuota()
{ return testa==NULL; }

void Pila::Push(int e)
{
  Rec* tmp = new Rec;
  tmp->info = e;
  tmp->next = testa;
  testa = tmp;
}

void Pila::Pop()
{
  Rec* tmp = testa;
  testa = testa->next;
  delete tmp;
}

int Pila::Top()
{ return testa->info; }


Rec* Pila::Copia(Rec* l)
{
  if (l==NULL) return NULL;
  else {
    Rec* ris = new Rec;
    ris->info = l->info;
    ris->next = Copia(l->next);
    return ris;
  }
}

void Pila::Cancella(Rec* l)
{
  while (l!=NULL) {
    Rec* tmp = l;
    l = l->next;
    delete tmp;
  }
}
