//coda.cpp
//usa array "circolare"

#include "coda.h"


Coda::Coda()  //costruttore a 0 arg. implementa CodaVuota
{
  dimmax = 10;
  vett = new int[dimmax];
  testa = 0;
  coda = 0;
  numelem = 0;
}

Coda::~Coda() //distruttore
{ delete[] vett; }

Coda::Coda(const Coda& c)  //costruttore di copia
{
  dimmax = 10;
  vett = new int[dimmax];
  testa = c.testa;
  coda = c.coda;
  numelem = c.numelem;
  for (int i = 0; i < numelem; i++)
    vett[(testa+i)%dimmax] = c.vett[(testa+i)%dimmax];
}

Coda& Coda::operator=(const Coda& c)  //overloading assegnazione
{
  if (this != &c) {
    delete[] vett;
    dimmax = 10;
    vett = new int[dimmax];
    testa = c.testa;
    coda = c.coda;
    numelem = c.numelem;
    for (int i = 0; i < numelem; i++)
      vett[(testa+i)%dimmax] = c.vett[(testa+i)%dimmax];
  }
  return *this;
}

bool Coda::EstVuota()
{ return numelem == 0; }

void Coda::InCoda(int e)
{
  if (numelem == dimmax) return;

  vett[coda] = e;
  coda = (coda+1)%dimmax;
  numelem = numelem+1;
}

void Coda::OutCoda()
{
  if (numelem == 0) return;
  
  testa = (testa+1)%dimmax;
  numelem = numelem-1;
}

int Coda::Primo()
{ 
  if (numelem == 0) return -1;

  return vett[testa]; 
}
