//coda.cpp
#include "coda.h"

Coda::Coda()  //costruttore a 0 arg. implementa CodaVuota
{
  testa = new Rec; //record dummy
  coda = testa;

}

Coda::~Coda() //distruttore
{ Cancella(); }

Coda::Coda(const Coda& c)  //costruttore di copia
{
  Copia(c.testa);
}

Coda& Coda::operator=(const Coda& c)  //overloading assegnazione
{
  if (this != &c) {
    Cancella();
    Copia(c.testa);
  }
  return *this;
}

bool Coda::EstVuota()
{ return testa == coda; }

void Coda::InCoda(int e)
{
  coda->next = new Rec;
  coda = coda->next;
  coda->info = e;
  coda->next = NULL;
}

void Coda::OutCoda()
{
  if (testa != coda) {
    Rec* tmp = testa;
    testa = testa->next;
    delete tmp;
  }
}

int Coda::Primo()
{ return testa->next->info; }


void Coda::Copia(Rec* l)
{
  testa = new Rec; //record dummy;
  coda = testa;
  while (l->next!=NULL) { //nota: il primo record di l non e' significativo
    coda->next = new Rec;
    coda = coda->next;
    l = l->next;
    coda->info = l->info;
  }
  coda->next = NULL;
}

void Coda::Cancella()
{
  while (testa!=NULL) {
    Rec* tmp = testa;
    testa = testa->next;
    delete tmp;
  }
}
