//coda.cpp
#include "coda.h"

Coda::Coda()  //costruttore a 0 arg. implementa CodaVuota
{
  testa = NULL; //coda rimane con un valore non significativo
}

Coda::~Coda() //distruttore
{ Cancella(); }

Coda::Coda(const Coda& c)  //costruttore di copia
{
  Copia(c.testa);
}

Coda& Coda::operator=(const Coda& c)  //overloading assegnazione
{
  if (this != &c) {
    Cancella();
    Copia(c.testa);
  }
  return *this;
}

bool Coda::EstVuota()
{ return testa == NULL; }

void Coda::InCoda(int e)
{
  if (testa == NULL) {
    testa = new Rec;
    testa->info = e;
    testa->next = NULL;
    coda = testa;
  }
  else {
    coda->next = new Rec;
    coda = coda->next;
    coda->info = e;
    coda->next = NULL;
  }
}

void Coda::OutCoda()
{
  if (testa != NULL) {
    Rec* tmp = testa;
    testa = testa->next;
    delete tmp;
  }
}

int Coda::Primo()
{ return testa->info; }


void Coda::Copia(Rec* l)
{
  if (l == NULL)
    testa = NULL;
  else {
    testa = new Rec;
    testa->info = l->info;
    coda = testa;
    l = l->next;
    while (l!=NULL) {
      coda->next = new Rec;
      coda = coda->next;
      coda->info = l->info;
      l = l->next;
    }
    coda->next = NULL;
  }
}

void Coda::Cancella()
{
  while (testa!=NULL) {
    Rec* tmp = testa;
    testa = testa->next;
    delete tmp;
  }
}
