// File tempo.cpp
// Contiene la definizione delle funzioni della classe tempo
#include "tempo.h"

int tempo::Ore()
{ return sec / 3600; }
        
int tempo::Minuti()
{ return (sec - (sec / 3600)*3600) / 60; }
 
int tempo::Secondi()
{ return sec % 60; }

tempo::tempo()
{ sec = 0; }

tempo::tempo(int o, int m)
{ if (o < 0 || o > 24 || m < 0 || m > 60)
    sec = 0;
  else sec = long(o)*3600 + m*60;
}
tempo::tempo(int o, int m, int s)
{ if (o < 0 || o > 24 || m < 0 || m > 60 || s < 0 || s > 60)
     sec = 0;
  else sec = long(o)*3600 + m*60 + s;
}

bool tempo::operator==(tempo t)  // overloading dell'operatore "=="
{ return sec == t.sec; }

tempo tempo::operator+(tempo t)
{ tempo aux;
  aux.sec = (t.sec + sec) % 86400;
  return aux;
}

bool tempo::operator<(tempo t) // overloading dell'operatore "<"
{ return sec < t.sec; }

