// File datatempo.h
#include <iostream.h>
#include "datatempo.h"

datatempo::datatempo()
{ giorno = 1;
  mese = 1;
  anno = 1900;
}

datatempo::datatempo(int a, int me, int g, int o, int mi, int s)
     :tempo(o,mi,s)
{ giorno = g;
  mese = me;
  anno = a;
}

datatempo datatempo::operator+(tempo t)
{ datatempo aux = *this;  // copia tutti i campi (giorno, ...)
  aux.sec = sec + 3600 * t.Ore() + 60 * t.Minuti() + t.Secondi();
  // nota: non possiamo scrivere aux.sec = sec + t.sec
  // datatempo.cpp:21: member `sec' is a protected member of class `tempo'
  if (aux.sec >= 86400)
    { aux.sec = aux.sec - 86400;
      aux.AvanzaUnGiorno();
    }
  return aux;
}

bool datatempo::operator<(datatempo t)
{ return anno < t.anno || 
         (anno == t.anno && mese < t.mese) ||
         (anno == t.anno && mese == t.mese && giorno < t.giorno) ||
         (anno == t.anno && mese == t.mese && 
          giorno == t.giorno && sec < t.sec);
}

void datatempo::Azzera()
{ sec = 0;  
  giorno = 1;
  mese = 1;
  anno = 2000;
}

void datatempo::AvanzaUnGiorno()
{ if (giorno == GiorniDelMese())
    if (mese == 12)  
      { giorno = 1;
        mese = 1;
        anno++;
      }
    else
      { giorno = 1;
        mese++;
      }
  else giorno++;
}

bool datatempo::Bisestile()
{ return ((anno % 4 == 0) && (anno % 100 != 0)) 
      || (anno % 400 == 0);
}

int datatempo::GiorniDelMese()
{ switch (mese)
    {case 2:
       if (Bisestile())
         return 29;
       else 
         return 28;
     case 4: case 6: case 9: case 11:
       return 30;
     default:
       return 31;
     }
}

