//File parametricompatibili.cpp
#include<iostream.h>

class B
{public:
  void f(B b) {cout << "f(B)\n";}
};

void g(B b) {cout << "g(B)\n";}

class D : private B //derivazione privata (o protetta)
{public:
  void h1(D d) {f(d);} //all'interno della classe D, D e' compatibile con B
  void h2(D d) {g(d);} //  "
  static void h3(D d) {g(d);} // "
};

//void p(D d) {g(d);} //ERR all'esterno di D, D non e' compatibile con B

void main() {
  D d1;
  D d2;
  d1.h1(d2);
  d1.h2(d2);
  D::h3(d1);
  //  g(d1); //ERR all'esterno di D, D non e' compatibile con B
}

/*output:
  f(B)
  g(B)
  g(B)
*/
