//Si consideri il seguente programma C++
/* 1*/  class B
/* 2*/  { private:
/* 3*/      void f();
/* 4*/    protected:
/* 5*/      void g();
/* 6*/    public:
/* 7*/      void h();
/* 8*/  };
/* 9*/  
/*10*/  class A: *ALFA* B
/*11*/  { private:
/*12*/      void fa() {f();}
/*13*/    public:
/*14*/      void ha() {g();}
/*15*/  };
/*16*/  
/*17*/  void main()
/*18*/  { A x; B y;
/*19*/    x.g();
/*20*/    x.h();
/*21*/    x.ha();
/*22*/    x.fa();
/*23*/    y.ha();
/*24*/    y.g();
/*25*/    y.h();
/*26*/  }

//Si analizzino i tre casi di: *ALFA*  uguale a public *ALFA*  uguale a
//protected *ALFA*  uguale a private e si indichino

/* Soluzione:

1. *ALFA* uguale a public:
Errori riportati dal compilatore gcc version 2.7.2

deriv.C: In method `void A::fa()':
deriv.C:3: method `void B::f()' is private
deriv.C:12: within this context
deriv.C: In function `int main(...)':
deriv.C:5: method `void B::g()' is protected
deriv.C:19: within this context
deriv.C:12: method `void A::fa()' is private
deriv.C:22: within this context
deriv.C:23: no member function `B::ha()' defined
deriv.C:5: method `void B::g()' is protected
deriv.C:24: within this context
5 Error(s) detected.

2. *ALFA* uguale a protected:
Tutti gli errori precedenti, inoltre:

deriv.C:7: method `void B::h()' has protected accessibility
deriv.C:20: within this context

3. *ALFA* uguale a private:
Tutti gli errori del caso 1, inoltre:

deriv.C:7: method `void B::h()' is from private base class
deriv.C:20: within this context

*/