// File TavolaHash.h
#ifndef TAVOLA_HASH_H
#define TAVOLA_HASH_H
#include "Token.h"
#include "Oggetto.h"

struct rec {
  Token* key;
  Oggetto* info;
  rec* next;
};

class TavolaHash
{public:
  TavolaHash();
  TavolaHash(int dim);
  ~TavolaHash();
  void Inserisci(Token* key, Oggetto* info);
  void Elimina(Token* key);
  Oggetto* Cerca(Token* key);
 protected:
  rec** tavola;
  int dimTavola;
  int numElem;
  void Rehash();
  int Hash(Token* key);
  void Rimuovi(Token* key, rec*& lista);
 private:
  TavolaHash(const TavolaHash&);  
  TavolaHash& operator=(const TavolaHash&);
};

#endif

