// File TavolaHash.cpp
#include <iostream.h>
#include "TavolaHash.h"

const int DIM = 101;

TavolaHash::TavolaHash()
{
  dimTavola = DIM;
  tavola = new rec*[dimTavola];
  for (int i = 0; i < dimTavola; i++) tavola[i] = NULL;
  numElem = 0;
}

TavolaHash::TavolaHash(int dim)
{
  dimTavola = dim;
  tavola = new rec*[dimTavola];
  for (int i = 0; i < dimTavola; i++) tavola[i] = NULL;
  numElem = 0;
}

TavolaHash::~TavolaHash()
{ delete[] tavola; }

void TavolaHash::Inserisci(Token* key, Oggetto* info)
{
  int i = Hash(key);
  rec* l = tavola[i];
  while (l != NULL) {
    if (key == l->key) return;
    l = l->next;
  }
  l = new rec;
  l->key = key;
  l->info = info;
  l->next = tavola[i];
  tavola[i] = l;
  numElem++;
  if (float(numElem)/dimTavola > 0.75) Rehash();
}

void TavolaHash::Elimina(Token* key)
{
  int i = Hash(key);
  Rimuovi(key, tavola[i]);
}

Oggetto* TavolaHash::Cerca(Token* key)
{
  int i = Hash(key);
  rec* l = tavola[i];
  while (l != NULL) {
    if (key == l->key) return l->info;
    l = l->next;
  }
  return NULL;
}

void TavolaHash::Rehash()
{
  int oldDim = dimTavola;
  rec** oldTavola = tavola;
  dimTavola = dimTavola*2+1; //raddoppio dimTavola (mantenendola dispari)
  tavola = new rec*[dimTavola];
  for (int i = 0; i < dimTavola; i++) tavola[i] = NULL;
  numElem = 0;
  for (int i = 0; i < oldDim; i++) {
    rec* l = oldTavola[i];
    while (l != NULL) {
      Inserisci(l->key,l->info);
      l = l->next;
    }
  }
  delete[] oldTavola;
}

int TavolaHash::Hash(Token* key)
{
  return int(key) % dimTavola;
}

void TavolaHash::Rimuovi(Token* key, rec*& l)
{
  if (l==NULL) return;
  else if (key == l->key) {
    rec* ll = l->next;
    delete l;
    l = ll;
    numElem--;
  }
  else Rimuovi(key, l->next);
}



