// File Guardaroba.cpp
#include <iostream.h>
#include "Guardaroba.h"

Guardaroba::Guardaroba() : TavolaHash(11)
{ numOggetti = 0; }

Token* Guardaroba::AggiungiOggetto(Oggetto& o)
{
  Token* t = new Token;
  Inserisci(t,&o);
  numOggetti++;
  return t;
}

bool Guardaroba::EstInGuardaroba(Token* t)
{ return Cerca(t)!= NULL; }

Oggetto* Guardaroba::RestituisciOggetto(Token* t)
{
  Oggetto* ris = Cerca(t);
  Elimina(t);
  numOggetti--;
  return ris;
}

Array Guardaroba::OggettiPresenti()
{
  elem* array = new elem[numOggetti];
  int k = 0;
  for (int i = 0; i < dimTavola; i++) {
    rec* aux = tavola[i];
    while (aux != NULL) {
      array[k].tok = aux->key;
      array[k].ogg = aux->info;
      k++;
      aux = aux->next;
    }
  }
  Array ris;
  ris.array = array;
  ris.dimArray = numOggetti;
  return ris;
}
