class Voce {
  public String parola;
  public String definizione;
}


public class Dizionario2 {
  //costante
  private static final int dimIniz = 5;

  //rappresentazione degli oggetti
  private Voce[] array;
  private int numElem;

  //metodi pubblici
  public Dizionario2() {
    array = new Voce[dimIniz];
    numElem = 0;
  }

  public String cerca(String parola) {
    for (int i = 0; i < numElem; i++)
      if(array[i].parola.equals(parola))
        return array[i].definizione;
    return null;
  }

  public void inserisci(String parola, String definizione) {
    if (numElem == array.length) {
      //ingrandisci l'array
      Voce[] aux = new Voce[array.length*2]; // Crea array aux piu' grande.
      for(int i = 0; i < numElem; i++)       // Copiaci gli elementi
        aux[i] = array[i];                   // dell'array originale.
      array = aux;           // Sostituisci nuovo array all'array originale.
    }

    // nell'array c'e' spazio per la nuova voce e possiamo operare come in
    // Dizionario1
    Voce c = new Voce();
    c.parola = parola;
    c.definizione = definizione;
    array[numElem] = c;
    numElem++;
  }

  public void elimina(String parola) {
    // inizialmente operiamo in modo analogo a Dizionario1, usando pero' una
    // variabile booleana per uscire dal ciclo appena si e' eliminato un
    // elemento
    boolean trovato = false;
    for (int i = 0; i < numElem && !trovato; i++)
      if (array[i].parola.equals(parola)) {
        array[i] = array[numElem-1];
        array[numElem-1] = null;
        numElem--;
        trovato = true;
      }
    // se array troppo vuoto, rimpiccioliscilo
    if (numElem > dimIniz && numElem < array.length/4) {
      Voce[] aux = new Voce[array.length/2];
      for(int i = 0; i < numElem; i++) 
        aux[i] = array[i];
      array = aux;
    }
  }       

  public void eliminaTutte(String parola) {
    // inizialmente operiamo come in Dizionario1
    for (int i = 0; i < numElem; i++)
      if (array[i].parola.equals(parola)) {
        array[i] = array[numElem-1];
        array[numElem-1] = null;
        numElem--;
      }
    // se array troppo vuoto, rimpiccioliscilo
    if (numElem > dimIniz && numElem < array.length/4) {
      Voce[] aux = new Voce[array.length/2];
      for(int i = 0; i < numElem; i++) 
        aux[i] = array[i];
      array = aux;
    }
  }       

  public String toString() {
    String ris = "numElem: " + numElem + ", dimArray: " + array.length + "\n";
    for (int i = 0; i < numElem; i++)
      ris = ris + array[i].parola + ": " + array[i].definizione + "\n";

    //il codice seguente inserisce nella stringa anche gli elementi non
    //significativi, per verificare che vengano effettivamente posti a null
    //for (int i = 0; i < array.length; i++)
    //  ris = ris + i + " " +
    //    ((array[i] == null)? "null\n" : (array[i].parola + ": " +
    //                                     array[i].definizione + "\n"));
    return ris;
  }    
}
