class Voce {
  public String parola;
  public String definizione;
}


public class Dizionario1 {

  //rappresentazione degli oggetti
  private Voce[] array;
  private int numElem;
  

  //metodi pubblici
  public Dizionario1(int n) {
    array = new Voce[n];
    numElem = 0;
  }

  public String cerca(String parola) {
    for (int i = 0; i < numElem; i++)
      if(array[i].parola.equals(parola))
        return array[i].definizione;
    return null;
  }

  public void inserisci(String parola, String definizione) {
    if (numElem == array.length) 
      throw new RuntimeException("Dizionario pieno");
    else {
      Voce c = new Voce();
      c.parola = parola;
      c.definizione = definizione;
      array[numElem] = c;
      numElem++;
    }
  }
      
  public void elimina(String parola) {
    for (int i = 0; i < numElem; i++) 
      if (array[i].parola.equals(parola)) {
        array[i] = array[numElem-1]; //sposta l'ultima voce
        array[numElem-1] = null; //pone l'ultima voce pari a null
                                 //permettendo al garbage collector di operare
        numElem--;               //aggiorna num elem. presenti
        return;
      }
  }


  public void eliminaTutte(String parola) {
    for (int i = 0; i < numElem; i++) 
      if (array[i].parola.equals(parola)) {
        array[i] = array[numElem-1]; //sposta l'ultima voce
        array[numElem-1] = null; //pone l'ultima voce pari a null
                                 //permettendo al garbage collector di operare
        numElem--;               //aggiorna num elem. presenti
      }
  }

  public String toString() {
    String ris = "numElem: " + numElem + ", dimArray: " + array.length + "\n";
    for (int i = 0; i < numElem; i++) 
      ris = ris + array[i].parola + ": " + array[i].definizione + "\n";
    return ris;
  }
}
