/*=============================================================================*
 *  Copyright 2006 The Apache Software Foundation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *=============================================================================*/
 
package org.apache.muse.test.wsrf;

import org.apache.muse.core.AbstractCapability;
import org.apache.muse.core.Resource;
import org.apache.muse.core.ResourceManager;
import org.apache.muse.ws.addressing.soap.SoapFault;

public class MyFactoryImpl extends AbstractCapability implements MyFactory
{
    public void initializeCompleted() 
        throws SoapFault
    {
        super.initializeCompleted();
        
        Thread resourceCreationThread = new Thread(){
            public void run()
            {
                ResourceManager manager = getResource().getResourceManager();
                
                try
                {
                    while (true)
                    {
                        Thread.currentThread().sleep(7000);
                        Resource next = manager.createResource("WsResource");
                        next.initialize();
                        manager.addResource(next.getEndpointReference(), next);
                    }
                }
                
                catch (Throwable error)
                {
                    error.printStackTrace();
                }
            }            
        };
        resourceCreationThread.start();        
    }
}
