/*=============================================================================*
 *  Copyright 2006 The Apache Software Foundation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *=============================================================================*/

package org.apache.ws.muse.test.wsrf;

import javax.xml.namespace.QName;

import org.w3c.dom.Element;

import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.notification.NotificationProducer;
import org.apache.muse.ws.notification.WsnConstants;
import org.apache.muse.ws.resource.impl.AbstractWsResourceCapability;

public class MyCapabilityImpl extends AbstractWsResourceCapability implements MyCapability
{
    private static final QName[] _PROPERTIES = new QName[] {
            new QName(NAMESPACE_URI, "MessageInterval", PREFIX),
            new QName(NAMESPACE_URI, "ServerName", PREFIX) 
    };

    private static final QName _TOPIC_NAME = new QName(NAMESPACE_URI, "MyTopic", PREFIX);
    
    public QName[] getPropertyNames()
    {
        return _PROPERTIES;
    }

    private int _MessageInterval = 10;

    private String _ServerName = "muse-test.apache.org";

    public int getMessageInterval()
    {
        return _MessageInterval;
    }

    public void setMessageInterval(int param0)
    {
        _MessageInterval = param0;
    }

    public String getServerName()
    {
        return _ServerName;
    }

    public void setServerName(String param0)
    {
        _ServerName = param0;
    }
    
    public void initializeCompleted() 
        throws SoapFault
    {
        super.initializeCompleted();
        
        //
        // access resource's WSN capability and create a new topic
        //
        final NotificationProducer wsn = (NotificationProducer)getResource().getCapability(WsnConstants.PRODUCER_URI);
        wsn.addTopic(_TOPIC_NAME);

        Thread producer = new Thread() {
            public void run()
            {
                //
                // for this example, reuse one payload for every notification
                //
                QName messageName = new QName(NAMESPACE_URI, "MyMessage", PREFIX);
                String message = "This is a message from " + getServerName();
                Element payload = XmlUtils.createElement(messageName, message);
                
                while (true)
                {
                    try
                    {
                        //
                        // read current value - property is mutable
                        //
                        int currentInterval = getMessageInterval();
                        
                        getLog().info("Waiting " + currentInterval + " seconds before sending message...");
                        Thread.currentThread().sleep(currentInterval * 1000);
                        
                        //
                        // use WSN capability to send message to any subscribers
                        //
                        getLog().info("Sending message to consumers...");
                        wsn.publish(_TOPIC_NAME, payload);
                    }

                    catch (Throwable error)
                    {
                        error.printStackTrace();
                    }
                }
            }
        };
        producer.start();
    }
}
