/*=============================================================================*
 *  Copyright 2006 The Apache Software Foundation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *=============================================================================*/
 
package org.apache.muse.test.wsn;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;

import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.notification.remote.NotificationProducerClient;

public class WsnTestClient
{    
    public static URI getLocalAddress(String contextPath, int port) 
        throws UnknownHostException
    {
        String ip = InetAddress.getLocalHost().getHostAddress();
        
        StringBuffer address = new StringBuffer();
        address.append("http://");
        address.append(ip);
        address.append(':');
        address.append(port);
        
        if (contextPath.charAt(0) != '/')
            address.append('/');
            
        address.append(contextPath);
        
        return URI.create(address.toString());
    }
    
    public static void main(String[] args)
    {
        try
        {
            //
            // change these to point to different applications/servers
            //
            String webAppRoot = "/wsn-producer/services";
            int producer_port = Integer.parseInt(System.getProperty("producer_port","8080"));
            int consumer_port = Integer.parseInt(System.getProperty("consumer_port","8080"));
                        
            //
            // create producer EPR/client, and use it to subscribe 
            // the consumer to all messages
            //
            
            String contextPath = webAppRoot + "/WsResource";
            URI address = getLocalAddress(contextPath, producer_port);
            EndpointReference epr = new EndpointReference(address);
            
            webAppRoot = "/wsn-consumer/services";
            contextPath = webAppRoot + "/consumer";
            address = getLocalAddress(contextPath, consumer_port);
            EndpointReference consumer = new EndpointReference(address);
            
            //
            // null filter == send all messages to consumer
            //
            NotificationProducerClient producer = new NotificationProducerClient(epr);
            producer.setTrace(true);
            producer.subscribe(consumer, null, null);
        }
        
        catch (Throwable error)
        {
            error.printStackTrace();
        }
    }
}
