/*=============================================================================*
 *  Copyright 2006 The Apache Software Foundation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *=============================================================================*/

package org.apache.muse.test.simple.second;

import javax.xml.namespace.QName;

import org.apache.muse.core.Capability;

public interface SecondCapability extends Capability
{
    String NAMESPACE_URI = "http://ws.apache.org/muse/test/simple/second";
    
    String PREFIX = "second";
    
    String SECOND_OP_URI = NAMESPACE_URI + "/SecondOperation";
    
    QName SECOND_OP_QNAME = new QName(NAMESPACE_URI, "SecondOperation", PREFIX);
    
    QName PARAM1_QNAME = new QName(NAMESPACE_URI, "Param1", PREFIX);
    
    QName PARAM2_QNAME = new QName(NAMESPACE_URI, "Param2", PREFIX);
    
    boolean secondOperation(int param1, QName param2);
}
