/*=============================================================================*
 *  Copyright 2006 The Apache Software Foundation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *=============================================================================*/

package org.apache.muse.test.simple;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;

import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;

import org.w3c.dom.Element;

import org.apache.muse.core.routing.CounterResourceIdFactory;
import org.apache.muse.core.routing.ResourceIdFactory;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.metadata.remote.MetadataExchangeClient;

/**
 * 
 * SimpleTestClient is a simple test driver that invokes the two user-defined 
 * operations in FirstCapability and SecondCapability, as well as the GetMetadata 
 * operation from WS-MetadataExchange. The WSDL retrieved via WS-MetadataExchange 
 * is run through the WSDL4J parser to make sure it was serialized properly.
 *
 * @author Dan Jemiolo (danjemiolo)
 *
 */

public class SimpleTestClient
{
    public static void addReferenceParameter(EndpointReference epr)
    {
        ResourceIdFactory factory = new CounterResourceIdFactory();
        QName name = factory.getIdentifierName();
        String value = factory.getNextIdentifier();
        epr.addParameter(name, value);
    }
    
    public static URI getLocalAddress(String contextPath, int port) 
        throws UnknownHostException
    {
        String ip = InetAddress.getLocalHost().getHostAddress();
        
        StringBuffer address = new StringBuffer();
        address.append("http://");
        address.append(ip);
        address.append(':');
        address.append(port);
        
        if (contextPath.charAt(0) != '/')
            address.append('/');
            
        address.append(contextPath);
        
        return URI.create(address.toString());
    }
    
    public static void main(String[] args)
    {
        try
        {
            //
            // change these to point to different applications/servers
            //
            String contextPath = "/simple/services/SimpleResource";
            int port = 8080; 
            
            //
            // create EPR for test resource
            //
            URI address = getLocalAddress(contextPath, port);
            EndpointReference epr = new EndpointReference(address);
            
            addReferenceParameter(epr);
            
            //
            // create proxy - turn on tracing of SOAP messages
            //
            SimpleResourceClient client = new SimpleResourceClient(epr);
            client.setTrace(true);
            
            //
            // test FirstCapability.firstOperation
            //
            client.firstOperation("Hello, World!");
            
            //
            // test SecondCapability.secondOperation
            //
            client.secondOperation(42, new QName("http://ibm.com", "Test", "ibm"));
            
            //
            // test WS-MEx GetMetadata with WSDL dialect
            //
            MetadataExchangeClient wsxClient = new MetadataExchangeClient(epr);
            wsxClient.setTrace(true);
            
            //
            // make sure WSDL is valid using WSDL4J
            //
            Element wsdl = wsxClient.getWSDL();
            WSDLFactory.newInstance().newWSDLReader().readWSDL((String)null, wsdl);
        }
        
        catch (Throwable error)
        {
            error.printStackTrace();
        }
    }
}
