/*=============================================================================*
 *  Copyright 2006 The Apache Software Foundation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *=============================================================================*/

package org.apache.muse.test.simple;

import javax.xml.namespace.QName;

import org.w3c.dom.Element;

import org.apache.muse.core.AbstractResourceClient;
import org.apache.muse.test.simple.first.FirstCapability;
import org.apache.muse.test.simple.second.SecondCapability;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.soap.SoapClient;
import org.apache.muse.ws.addressing.soap.SoapFault;

/**
 * 
 * SimpleResourceClient is a web services client that implements the 
 * operations in FirstCapability and SecondCapability. This client 
 * was not generated by the Muse proxy generation tool because that 
 * code has not been modified to use the non-IBM/AC identifiers yet.
 *
 * @author Dan Jemiolo (danjemiolo)
 *
 */

public class SimpleResourceClient extends AbstractResourceClient
{
    public SimpleResourceClient(EndpointReference destination)
    {
        super(destination);
    }

    public SimpleResourceClient(EndpointReference destination, EndpointReference source)
    {
        super(destination, source);
    }

    public SimpleResourceClient(EndpointReference destination, 
                                EndpointReference source, 
                                SoapClient soapClient)
    {
        super(destination, source, soapClient);
    }
    
    public String firstOperation(String param1)
        throws SoapFault
    {
        Element body = XmlUtils.createElement(FirstCapability.FIRST_OP_QNAME, param1);
        Element response = invoke(FirstCapability.FIRST_OP_URI, body);
        return XmlUtils.extractText(response);
    }
    
    public boolean secondOperation(int param1, QName param2)
        throws SoapFault
    {
        Element body = XmlUtils.createElement(SecondCapability.SECOND_OP_QNAME);
        XmlUtils.setElement(body, SecondCapability.PARAM1_QNAME, new Integer(param1));
        XmlUtils.setElement(body, SecondCapability.PARAM2_QNAME, param2);
        
        Element response = invoke(SecondCapability.SECOND_OP_URI, body);
        return XmlUtils.getBoolean(response).booleanValue();
    }
}
