/*=============================================================================*
 *  Copyright 2006 The Apache Software Foundation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *=============================================================================*/

package org.apache.muse.test.http.testapp;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;

import org.apache.muse.ws.addressing.EndpointReference;

import org.apache.muse.test.http.SupportedLanguage;
import org.apache.muse.test.http.remote.HttpServerClient;

public class HttpServerTestApp
{    
    public static URI getLocalAddress(String contextPath, int port)
    {
        String ip = "localhost";
        
        try
        {
            ip = InetAddress.getLocalHost().getHostAddress();
        }
        
        catch (UnknownHostException error)
        {
            System.out.println("[WARNING] Could not read local IP address - using 'localhost' instead.");
        }
        
        StringBuffer address = new StringBuffer();
        address.append("http://");
        address.append(ip);
        address.append(':');
        address.append(port);
        
        if (contextPath.charAt(0) != '/')
            address.append('/');
            
        address.append(contextPath);
        
        return URI.create(address.toString());
    }
    
    public static void main(String[] args)
    {
        //
        // change these to point to different applications/servers
        //
        String contextPath = "/apache-httpd/services/http-server";
        int port = 8080;
        
        //
        // create EPR for test resource
        //
        URI address = getLocalAddress(contextPath, port);
        EndpointReference epr = new EndpointReference(address);
        
        //
        // create proxy - turn on tracing of SOAP messages
        //
        HttpServerClient http = new HttpServerClient(epr);
        http.setTrace(true);
        
        try
        {
            
            //
            // start server
            //
            http.start();
            
            //
            // read/print some property values
            //
            String httpName = http.getName();
            int httpPort = http.getPort();
            SupportedLanguage[] httpLang = http.getSupportedLanguage();
            
            System.out.println("Name: " + httpName);
            System.out.println("Port: " + httpPort);
            
            System.out.println("Supported Languages:");
            
            for (int n = 0; n < httpLang.length; ++n)
                System.out.println("\t" + httpLang[n]);
        }
        
        catch (Throwable error)
        {
            error.printStackTrace();
        }
        
        try
        {
            //
            // stop server
            //
            http.stop();
        }
        
        catch (Throwable error)
        {
            error.printStackTrace();
        }
    }
}
