/*=============================================================================*
 *  Copyright 2006 The Apache Software Foundation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *=============================================================================*/

package org.apache.muse.test.http.remote;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import javax.xml.namespace.QName;

import org.apache.muse.core.Environment;
import org.apache.muse.core.proxy.ProxyHandler;
import org.apache.muse.core.proxy.ReflectionProxyHandler;
import org.apache.muse.core.serializer.SerializerRegistry;
import org.apache.muse.test.http.SupportedLanguage;
import org.apache.muse.test.http.SupportedLanguageSerializer;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.soap.SoapClient;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.resource.remote.WsResourceClient;

public class HttpServerClient extends WsResourceClient
{
    public HttpServerClient(EndpointReference arg0)
    {
        super(arg0);
    }

    public HttpServerClient(EndpointReference arg0, EndpointReference arg1)
    {
        super(arg0, arg1);
    }

    public HttpServerClient(EndpointReference arg0, 
                            EndpointReference arg1, 
                            Environment arg2)
    {
        super(arg0, arg1, arg2);
    }

    public HttpServerClient(EndpointReference arg0, 
                            EndpointReference arg1, 
                            SoapClient arg2)
    {
        super(arg0, arg1, arg2);
    }
    
    public Date getCurrentTime()
        throws SoapFault
    {
        Date[] results = (Date[])getPropertyAsObject(PROPERTIES[0], Date.class);
        return results.length == 0 ? null : results[0];
    }
    
    public String getName()
        throws SoapFault
    {
        String[] results = (String[])getPropertyAsObject(PROPERTIES[1], String.class);
        return results.length == 0 ? null : results[0];
    }
    
    public int getPort()
        throws SoapFault
    {
        Integer[] results = (Integer[])getPropertyAsObject(PROPERTIES[2], Integer.class);
        return results.length == 0 ? -1 : results[0].intValue();
    }
    
    public SupportedLanguage[] getSupportedLanguage()
        throws SoapFault
    {
        return (SupportedLanguage[])getPropertyAsObject(PROPERTIES[3], SupportedLanguage.class);
    }
    
    public Date getTerminationTime()
        throws SoapFault
    {
        Date[] results = (Date[])getPropertyAsObject(PROPERTIES[4], Date.class);
        return results.length == 0 ? null : results[0];
    }
    
    public void start()
        throws SoapFault
    {
        Object[] args = new Object[0];
        
        ProxyHandler handler = getHandler(_METHOD_NAMES[0]);
        invoke(handler, args);
    }
    
    public void stop()
        throws SoapFault
    {
        Object[] args = new Object[0];
        
        ProxyHandler handler = getHandler(_METHOD_NAMES[1]);
        invoke(handler, args);        
    }
    
    public static final QName[] PROPERTIES = { 
        new QName("http://docs.oasis-open.org/wsrf/rl-2", "CurrentTime", "wsrf-rl"), 
        new QName("http://ws.apache.org/muse/test/http-server", "Name", "http"), 
        new QName("http://ws.apache.org/muse/test/http-server", "Port", "http"),  
        new QName("http://ws.apache.org/muse/test/http-server", "SupportedLanguage", "http"),  
        new QName("http://docs.oasis-open.org/wsrf/rl-2", "TerminationTime", "wsrf-rl")
    };

    private static final Map _HANDLERS_BY_NAME = new HashMap();

    private static final String[] _METHOD_NAMES = {
        "start", "stop" 
    };

    private static final Class[] _RETURN_TYPES = {
        void.class, void.class 
    };

    private static final String[] _ACTIONS = {
        "http://ws.apache.org/muse/test/http-server/Start", 
        "http://ws.apache.org/muse/test/http-server/Stop" 
    };

    private static final QName[] _REQUEST_NAMES = {
        new QName("http://ws.apache.org/muse/test/http-server", "Start", "http"), 
        new QName("http://ws.apache.org/muse/test/http-server", "Stop", "http") 
    };

    private static final QName[] _RESPONSE_NAMES = {
        new QName("http://ws.apache.org/muse/test/http-server", "StartResponse", "http"), 
        new QName("http://ws.apache.org/muse/test/http-server", "StopResponse", "http") 
    };

    private static final QName[][] _REQUEST_PARAM_NAMES = {
        new QName[] {
            
        }, 
        new QName[]{ 
            
        }
    };

    protected ProxyHandler getHandler(String methodName)
    {
        return (ProxyHandler)_HANDLERS_BY_NAME.get(methodName);
    }

    static
    {
        for (int n = 0; n < _METHOD_NAMES.length; ++n)
        {
            ProxyHandler handler = new ReflectionProxyHandler();
            handler.setAction(_ACTIONS[n]);
            handler.setRequestName(_REQUEST_NAMES[n]);
            handler.setRequestParameterNames(_REQUEST_PARAM_NAMES[n]);
            handler.setResponseName(_RESPONSE_NAMES[n]);
            handler.setReturnType(_RETURN_TYPES[n]);

            _HANDLERS_BY_NAME.put(_METHOD_NAMES[n], handler);
        }
        
        SerializerRegistry registry = SerializerRegistry.getInstance();
        registry.registerSerializer(SupportedLanguage.class, new SupportedLanguageSerializer());
    }
}
