/*=============================================================================*
 *  Copyright 2006 The Apache Software Foundation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *=============================================================================*/

package org.apache.muse.test.http;

import javax.xml.namespace.QName;

import org.w3c.dom.Element;

import org.apache.muse.core.serializer.Serializer;
import org.apache.muse.util.xml.XmlUtils;

public class SupportedLanguageSerializer implements Serializer
{    
    public Class getSerializableType()
    {
        return SupportedLanguage.class;
    }

    public Object fromXML(Element arg0)
    {
        String langCode = XmlUtils.getElementText(arg0, HttpServer.LANG_CODE_QNAME);
        String fileSuffix = XmlUtils.getElementText(arg0, HttpServer.FILE_SUFFIX_QNAME);
        return new SupportedLanguage(langCode, fileSuffix);
    }

    public Element toXML(Object arg0, QName arg1)
    {
        SupportedLanguage sl = (SupportedLanguage)arg0;
        
        Element root = XmlUtils.createElement(arg1);
        XmlUtils.setElement(root, HttpServer.LANG_CODE_QNAME, sl.getLanguageCode());
        XmlUtils.setElement(root, HttpServer.FILE_SUFFIX_QNAME, sl.getFileSuffix());
        
        return root;
    }
}
