/*=============================================================================*
 *  Copyright 2006 The Apache Software Foundation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *=============================================================================*/

package org.apache.muse.test.http;

import javax.xml.namespace.QName;

import org.apache.muse.ws.resource.WsResourceCapability;
import org.apache.muse.ws.resource.basefaults.BaseFault;

public interface HttpServer extends WsResourceCapability
{
    String NAMESPACE_URI = "http://ws.apache.org/muse/test/http-server";
    String PREFIX = "http";

    QName[] PROPERTIES = { 
        new QName(NAMESPACE_URI, "Name", PREFIX), 
        new QName(NAMESPACE_URI, "Port", PREFIX), 
        new QName(NAMESPACE_URI, "SupportedLanguage", PREFIX) 
    };
    
    QName LANG_CODE_QNAME = new QName(NAMESPACE_URI, "LangCode", PREFIX);
    
    QName FILE_SUFFIX_QNAME = new QName(NAMESPACE_URI, "FileSuffix", PREFIX);
    
    String getName()
        throws BaseFault;
    
    int getPort()
        throws BaseFault;
    
    SupportedLanguage[] getSupportedLanguage()
        throws BaseFault;
    
    void start()
        throws StartFailedFault;
    
    void stop()
        throws StopFailedFault;
}
