package org.apache.muse.test.producer;

import java.io.File;

import org.apache.muse.core.platform.osgi.util.BundleRootHelper;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Bundle;
import org.eclipse.core.runtime.FileLocator;

public class Activator implements BundleActivator {

	public void start(BundleContext context) throws Exception {
		String prop = System.getProperty("data.location");
		String dir = System.getProperty("user.dir");
		File root = null;
		if(prop == null){
			Bundle bundles[] = context.getBundles();
			for(int i=0;i<bundles.length;i++){
				if("org.eclipse.equinox.common".equals(bundles[i].getSymbolicName())){
					if(Bundle.ACTIVE != bundles[i].getState()){
						//Allow the exception to propogate - we're no good without the location
						bundles[i].start();
					}
					break;
				}
			}
			root = new File(FileLocator.resolve(context.getBundle().getEntry("/")).getFile());
		} else if("USE_BUNDLE_DATA".equals(prop)){
			root = context.getDataFile(".");
		} else {
			root = new File(prop);
		}
		BundleRootHelper.registerRoot(context.getBundle(), root);
	}

	public void stop(BundleContext context) throws Exception {
	}

}
