/*=============================================================================*
 *  Copyright 2006 The Apache Software Foundation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *=============================================================================*/

package test.muse.osgi.management.impl;

import org.apache.muse.core.AbstractCapability;
import test.muse.osgi.management.ConsumerCapability;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.notification.NotificationConsumer;
import org.apache.muse.ws.notification.NotificationMessage;
import org.apache.muse.ws.notification.NotificationMessageListener;
import org.apache.muse.ws.notification.WsnConstants;

public class ConsumerCapabilityImpl 
    extends AbstractCapability implements ConsumerCapability, NotificationMessageListener
{
    public void initializeCompleted() 
        throws SoapFault
    {
        super.initializeCompleted();
        
        NotificationConsumer wsn = (NotificationConsumer)getResource().getCapability(WsnConstants.CONSUMER_URI);
        wsn.addMessageListener(this);
    }
    
    public boolean accepts(NotificationMessage message)
    {
        return true;
    }

    public void process(NotificationMessage message)
    {
        getLog().info("Received message:\n\n" + message);
    }
}
