package test.muse.osgi.management;

import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;

import javax.xml.namespace.QName;
import java.util.Properties;

import org.apache.muse.core.platform.osgi.util.BundleRootHelper;
import org.apache.muse.core.routing.CounterResourceIdFactory;
import org.apache.muse.core.routing.ResourceIdFactory;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.dm.muws.remote.RelationshipsClient;
import org.apache.muse.ws.notification.remote.NotificationProducerClient;
import org.apache.muse.ws.resource.remote.WsResourceClient;
import org.apache.muse.ws.resource.sg.remote.ServiceGroupClient;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.w3c.dom.Element;

public class Activator implements BundleActivator {

	private EndpointReference consumer = null;
	private static Activator instance;
	private static boolean tracing = true;

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		System.out.println("Starting OSGI Manager bundle");
		String prop = System.getProperty("data.location");
		String dir = System.getProperty("user.dir");
		Properties props = System.getProperties();
		File curr = new File(".");
		System.out.println("curr dir" + curr.getCanonicalPath());
		File root = null;
		if(prop == null){
			String location = context.getBundle().getLocation();
			//WARNING - truly hacky code to get to proper install location
			if(location.startsWith("initial@reference:file:")){
				location = location.substring("initial@reference:file:".length());
				root = new File(location);
				location = root.getCanonicalPath();

				if(File.separator.equals("/")){
					int sample = location.lastIndexOf("samples/samples");
					if(sample > 0)
						location = patchupLocation(location, sample, "samples/eclipse-osgi/samples");
						root = new File(location);
				} else {
					int sample = location.lastIndexOf("samples\\samples");
					if(sample > 0)
						location = patchupLocation(location, sample, "samples\\eclipse-osgi\\samples");
						root = new File(location);
				}
			}
		} else if("USE_BUNDLE_DATA".equals(prop)){
			root = context.getDataFile(".");
		} else {
			root = new File(prop);
		}
		System.out.println("Using " + root.getCanonicalPath() + " as bundle root");
		BundleRootHelper.registerRoot(context.getBundle(), root);
		instance = this;
		Thread doTest = new Thread(){
			public void run(){
				try {
					Thread.sleep(1000);
					Activator.instance.runTest();
				} catch (InterruptedException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		};

		doTest.start();

	}

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
	}


    public static void addReferenceParameter(EndpointReference epr)
    {
        ResourceIdFactory factory = new CounterResourceIdFactory();
        QName name = factory.getIdentifierName();
        String value = factory.getNextIdentifier();
        epr.addParameter(name, value);
    }

    public static URI getLocalAddress(String contextPath, int port)
        throws UnknownHostException
    {
        String ip = InetAddress.getLocalHost().getHostAddress();

        StringBuffer address = new StringBuffer();
        address.append("http://");
        address.append(ip);
        address.append(':');
        address.append(port);

        if (contextPath.charAt(0) != '/')
            address.append('/');

        address.append(contextPath);

        return URI.create(address.toString());
    }

	private void runTest(){
        try
        {
            //
            // change these to point to different applications/servers
            //
            String webAppRoot = "/osgi-wsdm-muws/services";
            String contextPath = webAppRoot + "/OSGiServiceGroup";
            int port = 80;
            
            //
            // create EPR for test resource
            //
            URI address = getLocalAddress(contextPath, port);
            EndpointReference epr = new EndpointReference(address);
            
            addReferenceParameter(epr);

            //
            // create proxy - turn on tracing of SOAP messages
            //
            WsResourceClient client = new WsResourceClient(epr);
            client.setTrace(tracing);
            
            ServiceGroupClient sg = new ServiceGroupClient(epr);
            sg.setTrace(tracing);
            
            WsResourceClient[] members = sg.getMembers();
            
            System.out.println("Addresses of each service group entry:\n");
            
            EndpointReference repr = null;
            EndpointReference sepr = null;
            EndpointReference curr = null;

            for (int n = 0; n < members.length; ++n){
            	System.out.println(members[n].getEndpointReference());
            }
            for (int n = 0; n < members.length; ++n){
                System.out.println(members[n].getEndpointReference().getAddress());
                curr = members[n].getEndpointReference();
                if(curr.getAddress().toString().endsWith("OSGiBundleResource")){
                	String id = curr.getParameterString(new QName("http://ws.apache.org/muse/addressing", "ResourceId"));
                	if(repr == null && id != null && id.startsWith("dummy.bundle")){
                		repr = curr;
                	}
                }
                if(curr.getAddress().toString().endsWith("OSGiServiceResource")){
                	String id = curr.getParameterString(new QName("http://ws.apache.org/muse/addressing", "ResourceId"));
                	if(sepr == null && id != null && id.startsWith(("org.apache.muse.util.osgi.ResourceManagementImplementation"))){
                		sepr = curr;
                	}
                }
            }
            

            //Query bundle relationships
            epr = new EndpointReference(repr.getAddress());
            
            Element[] parms = repr.getParameters();
            for(int i=0;i<parms.length;i++){
            	epr.addParameter(parms[i]);
            }
            
            WsResourceClient resource_client = new WsResourceClient(repr);
            resource_client.setTrace(tracing);
            
            resource_client.getResourcePropertyDocument();

            RelationshipsClient rc = new RelationshipsClient(epr);
            rc.setTrace(tracing);
            QName names[] = {
            		new QName("http://resource.management.osgi/Bundle","Requires","osgi")
            };
            rc.queryRelationshipsByType(names);
            
            //Query service relationships
            epr = new EndpointReference(sepr.getAddress());
            parms = sepr.getParameters();
            for(int i=0;i<parms.length;i++){
            	epr.addParameter(parms[i]);
            }
            
            rc = new RelationshipsClient(epr);
            rc.setTrace(tracing);
            QName service_names[] = {
            		new QName("http://resource.management.osgi/Service","ServiceProvider","osgi")
            };
            rc.queryRelationshipsByType(service_names);
        }
        
        catch (Throwable error)
        {
            error.printStackTrace();
        }
		
	}


	private String patchupLocation(String location, int sampleStart, String replacementText){
		return location.substring(0,sampleStart)+replacementText + location.substring(sampleStart+"samples/samples".length());
	}

}
