package org.apache.muse.management.muse;

import org.apache.muse.core.Resource;
import org.apache.muse.core.ResourceManager;
import org.apache.muse.core.SimpleResourceManager;
import org.apache.muse.core.routing.RouterPersistence;
import org.apache.muse.core.routing.SimpleResourceRouter;
import org.apache.muse.management.common.Contribution;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.WsaConstants;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.eclipse.corona.management.osgi.BundleContribution;
import org.eclipse.corona.management.osgi.ServiceContribution;

public class ManagementResourceRouter extends SimpleResourceRouter {
	
	
	public void initialize() throws SoapFault {
		super.initialize();
		ManagementBinding.getDefault().setResourceRouter(this);
	}
	
    protected ResourceManager createResourceManager()
    {
        return new SimpleResourceManager();
    }
    	
	
	public Resource addNewResource(Contribution contribution) throws SoapFault{
		ResourceManager manager = getResourceManager();
		ManagementContributionProxy proxy = null;
		if(contribution instanceof BundleContribution)
			proxy = (ManagementContributionProxy)manager.createResource("/OSGiBundleResource");
		else if(contribution instanceof ServiceContribution)
			proxy = (ManagementContributionProxy)manager.createResource("/OSGiServiceResource");
		proxy.setContribution(contribution);
		proxy.initialize();
		//fix up the EPR with the resource ID
		EndpointReference epr = proxy.getEndpointReference();
		epr.addParameter(WsaConstants.DEFAULT_RESOURCE_ID_QNAME ,contribution.getIdentifier());
		manager.addResource(proxy.getEndpointReference(),proxy);
		return proxy;
	}

}
