package org.apache.muse.management.muse;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.ServiceListener;

import java.io.File;
import java.util.Hashtable;
import java.util.Properties;

import org.apache.muse.core.platform.osgi.ResourceManagementProvider;
import org.apache.muse.core.platform.osgi.util.BundleRootHelper;
import org.apache.muse.management.binding.Binding;

public class Activator implements BundleActivator {

	private ServiceRegistration bindingService;
	private ServiceReference managementServiceRef;
	private ResourceManagementProvider managementProvider;
	private BundleContext context;

	private static final String WSDM_PROVIDER_FILTER = "(objectclass=org.apache.muse.core.platform.osgi.ResourceManagementProvider)";

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		//Listen for WSDM service
		System.out.println("Starting OSGI Manager bundle");
		String prop = System.getProperty("data.location");
		String dir = System.getProperty("user.dir");
		Properties props = System.getProperties();
		File curr = new File(".");
		System.out.println("curr dir" + curr.getCanonicalPath());
		File root = null;
		if(prop == null){
			String location = context.getBundle().getLocation();
			//WARNING - truly hacky code to get to proper install location
			if(location.startsWith("initial@reference:file:")){
				location = location.substring("initial@reference:file:".length());
				root = new File(location);
				location = root.getCanonicalPath();

				if(File.separator.equals("/")){
					int sample = location.lastIndexOf("samples/samples");
					if(sample > 0)
						location = patchupLocation(location, sample, "samples/eclipse-osgi/samples");
						root = new File(location);
				} else {
					int sample = location.lastIndexOf("samples\\samples");
					if(sample > 0)
						location = patchupLocation(location, sample, "samples\\eclipse-osgi\\samples");
						root = new File(location);
				}
			}
		} else if("USE_BUNDLE_DATA".equals(prop)){
			root = context.getDataFile(".");
		} else {
			root = new File(prop);
		}
		System.out.println("Using " + root.getCanonicalPath() + " as bundle root");
		BundleRootHelper.registerRoot(context.getBundle(), root);

		this.context = context;
		managementServiceRef = context.getServiceReference("org.apache.muse.core.platform.osgi.ResourceManagementProvider");
		if(managementServiceRef != null){
			managementProvider = (ResourceManagementProvider)context.getService(managementServiceRef);
		}

		context.addServiceListener(new WSDMServiceListener(),WSDM_PROVIDER_FILTER);

		//publish the WSDMBinding service
		Hashtable providerProperties = new Hashtable();
		providerProperties.put(Binding.PROVIDER_NAME,"WSDM");
		providerProperties.put(Binding.PROVIDER_MAJOR_VERSION,new Integer(1));
		providerProperties.put(Binding.PROVIDER_MINOR_VERSION,new Integer(1));
		bindingService = context.registerService(
				"org.apache.muse.management.binding.Binding",
				ManagementBinding.getDefault(), providerProperties);

	}

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
	}

	private class WSDMServiceListener implements ServiceListener {

		public void serviceChanged(ServiceEvent event) {
			ServiceReference ref = event.getServiceReference();
			switch(event.getType()){
			case ServiceEvent.REGISTERED:
				managementProvider = (ResourceManagementProvider)context.getService(ref);
				managementServiceRef = ref;
				break;
			case ServiceEvent.MODIFIED:
				break;
			case ServiceEvent.UNREGISTERING:
				ref = event.getServiceReference();
				if(ref == managementServiceRef){
					managementServiceRef = null;
					managementProvider = null;
				}
				break;
			}
		}
	}

	private String patchupLocation(String location, int sampleStart, String replacementText){
		return location.substring(0,sampleStart)+replacementText + location.substring(sampleStart+"samples/samples".length());
	}




}
