package org.eclipse.corona.management.osgi;

import java.util.Locale;
import java.util.Set;

import org.apache.muse.management.common.Contribution;
import org.apache.muse.management.common.util.BundleUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

import org.osgi.framework.BundleContext;

public class ServiceContribution implements Contribution {
	
	private String uniqueId;
	ServiceReference service;
	
	public ServiceContribution(ServiceReference service){
		this.service = service;
		String[] services = (String[]) service.getProperty("objectClass");
		StringBuffer buffer = new StringBuffer();
		for(int i=0;i<services.length;i++){
			buffer.append(services[i]);
			if(i < services.length-1) buffer.append(",");
			else buffer.append("/");
		}
		buffer.append(service.getBundle().getSymbolicName());
		buffer.append("@");
		buffer.append(service.getBundle().getBundleId());
		buffer.append(":PID-");
		buffer.append(service.getProperty("service.pid"));
		uniqueId = buffer.toString(); 
	}
	
	public String getIdentifier() {
		return uniqueId;
	}
	
	public BundleContribution[] getServiceConsumers() throws Exception {
		return BundleUtils.getContributionsForBundles(service.getUsingBundles());
	}
	
	public BundleContribution getServiceProvider() throws Exception {
		return BundleUtils.getContributionForBundle(service.getBundle());
	}


}
