package org.eclipse.corona.management.osgi;

import java.util.HashMap;
import java.util.Iterator;

import org.apache.muse.management.binding.Binding;
import org.apache.muse.management.common.BindingProvider;
import org.apache.muse.management.common.Contribution;
import org.apache.muse.management.common.util.BundleUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class ContributionManager implements BundleListener, ServiceListener {
	
	private BundleContext context;
	private BindingProvider bindingProvider;
	private HashMap contributionToBundleMap = new HashMap();
	private HashMap contributionToServiceMap = new HashMap();
	private HashMap serviceToBundleMap = new HashMap();
	
	
	public void initialize(BundleContext context, BindingProvider bindingProvider){
		this.context = context;
		this.bindingProvider = bindingProvider;
		context.addBundleListener(this);
		context.addServiceListener(this);
		
		initializeBundles();
		initializeServices();
	}
	
	private void initializeBundles(){
		Bundle[] bundles = context.getBundles();
		for(int i=0;i<bundles.length;i++){
			//create initial resources
			contributionToBundleMap.put(bundles[i],createBundleContribution(bundles[i]));
		}
		Iterator j = bindingProvider.getBindings().iterator();
		while(j.hasNext()){
			Binding binding = (Binding)context.getService((ServiceReference)j.next());
			Iterator k = contributionToBundleMap.values().iterator();
			while(k.hasNext()){
				binding.bindContribution((Contribution)k.next());
			}
		}
	}
	
	private Contribution createBundleContribution(Bundle bundle){
		Contribution contribution = new BundleContribution(bundle);
		try {
			BundleUtils.registerContributionForBundle(bundle, contribution);
		} catch(Exception e){
			//TODO deal
		}
		return contribution;
	}
	


	public void bundleChanged(BundleEvent event) {
		Bundle bundle = event.getBundle();
		Contribution contribution = (Contribution)contributionToBundleMap.get(bundle);
		if(contribution instanceof BundleContribution == false) return;
		switch(event.getType()){
		case BundleEvent.INSTALLED:
			break;
		case BundleEvent.RESOLVED:
			break;
		case BundleEvent.STARTED:
			break;
		case BundleEvent.STARTING:
			break;
		case BundleEvent.STOPPED:
			Iterator j = bindingProvider.getBindings().iterator();
			while(j.hasNext()){
				Binding binding = (Binding)context.getService((ServiceReference)j.next());
				binding.unbindContribution(contribution);
			}
			break;
		case BundleEvent.STOPPING:			
			break;
		case BundleEvent.UNINSTALLED:
			break;
		case BundleEvent.UNRESOLVED:
			break;
		case BundleEvent.UPDATED:
			break;			
		}		
	}
	
	private void initializeServices(){
		ServiceReference[] services = null;
		try {
			services = context.getAllServiceReferences(null,null);
		} catch (InvalidSyntaxException e) {
			//This should never happen, since we don't provide a filter
		}
		if(services == null) return;
		for(int i=0;i<services.length;i++){
			//create initial resources
			contributionToServiceMap.put(services[i],createServiceContribution(services[i]));
		}
		Iterator j = bindingProvider.getBindings().iterator();
		while(j.hasNext()){
			Binding binding = (Binding)context.getService((ServiceReference)j.next());
			Iterator k = contributionToServiceMap.values().iterator();
			while(k.hasNext()){
				binding.bindContribution((Contribution)k.next());
			}
		}
	}
	
	private Contribution createServiceContribution(ServiceReference service){
		Contribution contribution = new ServiceContribution(service);
		return contribution;
	}

	
	public void serviceChanged(ServiceEvent event) {
		switch(event.getType()){
		case ServiceEvent.REGISTERED:
		case ServiceEvent.MODIFIED:
		case ServiceEvent.UNREGISTERING:
			break;
		}
		
	}
	
	public void bind(Binding binding){
		Iterator iter = contributionToBundleMap.values().iterator();
		while(iter.hasNext()){
			binding.bindContribution((Contribution)iter.next());
		}
		iter = contributionToServiceMap.values().iterator();
		while(iter.hasNext()){
			binding.bindContribution((Contribution)iter.next());
		}
	}

}
