package org.eclipse.corona.management.osgi;

import org.apache.muse.management.common.Contribution;
import org.apache.muse.management.common.util.BundleUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import java.util.Locale;

import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.BundleDescription;

import java.util.Set;
import java.util.Iterator;

public class BundleContribution implements Contribution {
	
	private String uniqueId;
	Bundle bundle;
	
	public BundleContribution(Bundle bundle){
		uniqueId = bundle.getSymbolicName() + "@" + bundle.getBundleId();
		this.bundle = bundle;
	}
	
	//Getters and Setters for properties
	public String getManifestHeader(String header){
		Locale.getDefault();
		return (String)bundle.getHeaders(Locale.getDefault().getCountry()).get(header);
	}
	
	public void start() throws BundleException {
		bundle.start();
	}

	public void stop() throws BundleException{
		bundle.start();
	}

	public String getIdentifier() {
		// TODO Auto-generated method stub
		return uniqueId;
	}
	
	public BundleContribution[] getBundleDependents() throws Exception {
		Set dependencies = BundleUtils.computeDependencies(bundle);
		return BundleUtils.getBundleDependencies(bundle);
	}
	

}
