package org.apache.muse.management.common;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceListener;

import org.apache.muse.management.binding.Binding;
import org.apache.muse.management.common.util.BundleUtils;
import org.eclipse.corona.management.osgi.BundleContribution;
import org.eclipse.corona.management.osgi.ContributionManager;

import java.util.Collection;
import java.util.Iterator;
import java.util.HashMap;

public class Activator implements BundleActivator, ServiceListener, BindingProvider {
	
	private BundleContext context;
	private HashMap bindings = new HashMap();
	private static final String BINDING_FILTER = "(objectclass=org.apache.muse.management.binding.Binding)";
	private ContributionManager osgiContributionManager = new ContributionManager();

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		this.context = context;
		BundleUtils.setBundleContext(context);
		initializeBindings();
		osgiContributionManager.initialize(context, this);
		context.addServiceListener(this, BINDING_FILTER);
	}

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
	}
	
	private void initializeBindings(){
		try {
			ServiceReference refs[] = context.getServiceReferences("org.apache.muse.management.binding.Binding", null);
			if(refs == null) return;
			for(int i=0;i<refs.length;i++){
				this.bindings.put(refs[i],refs[i]);
			}
		} catch (InvalidSyntaxException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	public void serviceChanged(ServiceEvent event) {
		ServiceReference ref = null;
		switch(event.getType()){
		case ServiceEvent.MODIFIED:
			break;
		case ServiceEvent.REGISTERED:
			ref = event.getServiceReference();
			bindings.put(ref, ref);
			//FIXME push functionality down to contribution manager
			Binding binding = (Binding)context.getService(ref);
			osgiContributionManager.bind(binding);
			break;
		case ServiceEvent.UNREGISTERING:
			bindings.remove(ref);
			break;
		}
		
	}

	public Collection getBindings() {
		return bindings.values();
	}

}
