#!/bin/sh

export SHELL_DIR=`dirname $0`
export MUSE_HOME=$SHELL_DIR/..

export MODULES_DIR=$MUSE_HOME/modules
export CORE_DIR=$MODULES_DIR/core
export TOOLS_DIR=$MODULES_DIR/tools
export API_DIR=$MODULES_DIR/ws-fx-api
export IMPL_DIR=$MODULES_DIR/ws-fx-impl
export COMMON_LIB_DIR=$MUSE_HOME/lib/common

export CLASSPATH=

for file in $CORE_DIR/*.jar; do
	export CLASSPATH=$file:$CLASSPATH;
done

for file in $TOOLS_DIR/*.jar; do
	export CLASSPATH=$file:$CLASSPATH;
done

for file in $API_DIR/*.jar; do
	export CLASSPATH=$file:$CLASSPATH;
done

for file in $IMPL_DIR/*.jar; do
	export CLASSPATH=$file:$CLASSPATH;
done

for file in $COMMON_LIB_DIR/*.jar; do
	export CLASSPATH=$file:$CLASSPATH;
done

if [ $OSTYPE == "cygwin" ]; then
    export CLASSPATH=$(cygpath -w --path $CLASSPATH)
    export MUSE_HOME=$(cygpath -w $MUSE_HOME)
fi
