/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.util.Headers;
import org.osgi.framework.Bundle;

public class ManifestLocalization {
    private AbstractBundle bundle = null;
    private Dictionary rawHeaders = null;
    private Dictionary defaultLocaleHeaders = null;
    private Hashtable cache = new Hashtable(5);

    public ManifestLocalization(AbstractBundle bundle, Dictionary rawHeaders) {
        this.bundle = bundle;
        this.rawHeaders = rawHeaders;
    }

    protected Dictionary getHeaders(String localeString) {
        if (localeString.length() == 0) {
            return this.rawHeaders;
        }
        boolean isDefaultLocale = false;
        String defaultLocale = Locale.getDefault().toString();
        if (localeString.equals(defaultLocale)) {
            if (this.defaultLocaleHeaders != null) {
                return this.defaultLocaleHeaders;
            }
            isDefaultLocale = true;
        }
        try {
            this.bundle.checkValid();
        }
        catch (IllegalStateException illegalStateException) {
            if (this.defaultLocaleHeaders != null) {
                return this.defaultLocaleHeaders;
            }
            return this.rawHeaders;
        }
        ResourceBundle localeProperties = this.getResourceBundle(localeString);
        if (localeProperties == null && !isDefaultLocale) {
            localeProperties = this.getResourceBundle(defaultLocale);
        }
        Enumeration e = this.rawHeaders.keys();
        Headers localeHeaders = new Headers(this.rawHeaders.size());
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)this.rawHeaders.get(key);
            if (value.startsWith("%") && value.length() > 1) {
                String propertiesKey = value.substring(1);
                try {
                    value = localeProperties == null ? propertiesKey : (String)localeProperties.getObject(propertiesKey);
                }
                catch (MissingResourceException missingResourceException) {
                    value = propertiesKey;
                }
            }
            localeHeaders.set(key, value);
        }
        if (isDefaultLocale) {
            this.defaultLocaleHeaders = localeHeaders;
        }
        return localeHeaders;
    }

    private String[] buildNLVariants(String nl) {
        int lastSeparator;
        ArrayList<String> result = new ArrayList<String>();
        while ((lastSeparator = nl.lastIndexOf(95)) != -1) {
            result.add(nl);
            if (lastSeparator == -1) continue;
            nl = nl.substring(0, lastSeparator);
        }
        result.add(nl);
        result.add("");
        return result.toArray(new String[result.size()]);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ResourceBundle getResourceBundle(String localeString) {
        BundleResourceBundle bundleResourceBundle;
        BundleResourceBundle result;
        String propertiesLocation = (String)this.rawHeaders.get("Bundle-Localization");
        if (propertiesLocation == null) {
            propertiesLocation = "OSGI-INF/l10n/bundle";
        }
        if ((result = (BundleResourceBundle)this.cache.get(localeString)) != null) {
            BundleResourceBundle bundleResourceBundle2;
            if (result.isEmpty()) {
                bundleResourceBundle2 = null;
                return (ResourceBundle)((Object)bundleResourceBundle2);
            }
            bundleResourceBundle2 = result;
            return (ResourceBundle)((Object)bundleResourceBundle2);
        }
        String[] nlVarients = this.buildNLVariants(localeString);
        BundleResourceBundle parent = null;
        int i = nlVarients.length - 1;
        while (true) {
            BundleResourceBundle varientBundle;
            block16: {
                if (i < 0) {
                    result = (BundleResourceBundle)this.cache.get(localeString);
                    if (!result.isEmpty()) break;
                    bundleResourceBundle = null;
                    return (ResourceBundle)((Object)bundleResourceBundle);
                }
                varientBundle = (BundleResourceBundle)this.cache.get(nlVarients[i]);
                URL varientURL = this.findResource(String.valueOf(propertiesLocation) + (nlVarients[i].equals("") ? nlVarients[i] : String.valueOf('_') + nlVarients[i]) + ".properties");
                if (varientURL != null) {
                    Object var10_10;
                    InputStream resourceStream = null;
                    try {
                        try {
                            resourceStream = varientURL.openStream();
                            varientBundle = new LocalizationResourceBundle(resourceStream);
                        }
                        catch (IOException iOException) {}
                    }
                    catch (Throwable throwable) {
                        var10_10 = null;
                        if (resourceStream == null) throw throwable;
                        try {
                            resourceStream.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    {
                        var10_10 = null;
                        if (resourceStream == null) break block16;
                    }
                    try {}
                    catch (IOException iOException) {}
                    resourceStream.close();
                }
            }
            if (varientBundle == null) {
                varientBundle = new EmptyResouceBundle();
            }
            if (parent != null) {
                varientBundle.setParent((ResourceBundle)((Object)parent));
            }
            this.cache.put(nlVarients[i], varientBundle);
            parent = varientBundle;
            --i;
        }
        bundleResourceBundle = result;
        return (ResourceBundle)((Object)bundleResourceBundle);
    }

    private URL findResource(String resource) {
        AbstractBundle searchBundle = this.bundle;
        if (this.bundle.isResolved()) {
            if (this.bundle.isFragment() && this.bundle.getHosts() != null && (searchBundle = this.bundle.getHosts()[0].getBundleHost()).getState() == 1) {
                searchBundle = this.bundle;
            }
            return this.findInResolved(resource, searchBundle);
        }
        return this.findInBundle(resource, searchBundle);
    }

    private URL findInResolved(String filePath, AbstractBundle bundleHost) {
        URL result = this.findInBundle(filePath, bundleHost);
        if (result != null) {
            return result;
        }
        return this.findInFragments(filePath, bundleHost);
    }

    private URL findInBundle(String filePath, AbstractBundle searchBundle) {
        return searchBundle.getEntry(filePath);
    }

    private URL findInFragments(String filePath, AbstractBundle searchBundle) {
        Bundle[] fragments = searchBundle.getFragments();
        URL fileURL = null;
        int i = 0;
        while (fragments != null && i < fragments.length && fileURL == null) {
            if (fragments[i].getState() != 1) {
                fileURL = fragments[i].getEntry(filePath);
            }
            ++i;
        }
        return fileURL;
    }

    private static interface BundleResourceBundle {
        public void setParent(ResourceBundle var1);

        public boolean isEmpty();
    }

    private class EmptyResouceBundle
    extends ResourceBundle
    implements BundleResourceBundle {
        private EmptyResouceBundle() {
        }

        public Enumeration getKeys() {
            return null;
        }

        protected Object handleGetObject(String arg0) throws MissingResourceException {
            return null;
        }

        public void setParent(ResourceBundle parent) {
            super.setParent(parent);
        }

        public boolean isEmpty() {
            if (this.parent == null) {
                return true;
            }
            return ((BundleResourceBundle)((Object)this.parent)).isEmpty();
        }
    }

    private class LocalizationResourceBundle
    extends PropertyResourceBundle
    implements BundleResourceBundle {
        public LocalizationResourceBundle(InputStream in) throws IOException {
            super(in);
        }

        public void setParent(ResourceBundle parent) {
            super.setParent(parent);
        }

        public boolean isEmpty() {
            return false;
        }
    }
}

