/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.saaj;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.Text;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.dom.DocumentImpl;
import org.apache.axiom.om.impl.dom.ElementImpl;
import org.apache.axiom.om.impl.dom.NamespaceImpl;
import org.apache.axiom.om.impl.dom.NodeImpl;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.impl.dom.soap11.SOAP11FaultImpl;
import org.apache.axis2.saaj.PrefixedQName;
import org.apache.axis2.saaj.SOAPBodyElementImpl;
import org.apache.axis2.saaj.SOAPElementImpl;
import org.apache.axis2.saaj.SOAPFaultImpl;
import org.apache.axis2.saaj.TextImplEx;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class SOAPBodyImpl
extends SOAPElementImpl
implements javax.xml.soap.SOAPBody {
    private SOAPBody omSOAPBody;
    private boolean isBodyElementAdded;

    public SOAPBodyImpl(SOAPBody omSOAPBody) {
        super((ElementImpl)omSOAPBody);
        this.omSOAPBody = omSOAPBody;
    }

    public SOAPElement addChildElement(String localName) throws SOAPException {
        if (this.omSOAPBody.hasFault()) {
            throw new SOAPException("A SOAPFault has been already added to this SOAPBody");
        }
        SOAPBodyElementImpl childEle = new SOAPBodyElementImpl((ElementImpl)this.getOwnerDocument().createElement(localName));
        childEle.element.setUserData("saaj.node", (Object)childEle, null);
        this.element.appendChild((org.w3c.dom.Node)childEle.element);
        ((NodeImpl)childEle.element.getParentNode()).setUserData("saaj.node", (Object)this, null);
        this.isBodyElementAdded = true;
        return childEle;
    }

    public SOAPElement addChildElement(String localName, String prefix) throws SOAPException {
        String namespaceURI = this.getNamespaceURI(prefix);
        if (namespaceURI == null) {
            throw new SOAPException("Namespace not declared for the give prefix: " + prefix);
        }
        SOAPBodyElementImpl childEle = new SOAPBodyElementImpl((ElementImpl)this.getOwnerDocument().createElementNS(namespaceURI, localName));
        childEle.element.setUserData("saaj.node", (Object)childEle, null);
        childEle.element.setNamespace(childEle.element.declareNamespace(namespaceURI, prefix));
        this.element.appendChild((org.w3c.dom.Node)childEle.element);
        ((NodeImpl)childEle.element.getParentNode()).setUserData("saaj.node", (Object)this, null);
        childEle.setParentElement(this);
        return childEle;
    }

    public SOAPElement addChildElement(SOAPElement soapElement) throws SOAPException {
        String namespaceURI = soapElement.getNamespaceURI();
        String prefix = soapElement.getPrefix();
        String localName = soapElement.getLocalName();
        this.element.declareNamespace(namespaceURI, prefix);
        SOAPBodyElementImpl childEle = new SOAPBodyElementImpl((ElementImpl)this.getOwnerDocument().createElementNS(namespaceURI, localName));
        Iterator iter = soapElement.getAllAttributes();
        while (iter.hasNext()) {
            Name name = (Name)iter.next();
            childEle.addAttribute(name, soapElement.getAttributeValue(name));
        }
        iter = soapElement.getChildElements();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o instanceof org.w3c.dom.Text) {
                childEle.addTextNode(((org.w3c.dom.Text)o).getData());
                continue;
            }
            childEle.addChildElement((SOAPElement)o);
        }
        childEle.element.setUserData("saaj.node", (Object)childEle, null);
        childEle.element.setNamespace(childEle.element.declareNamespace(namespaceURI, prefix));
        this.element.appendChild((org.w3c.dom.Node)childEle.element);
        ((NodeImpl)childEle.element.getParentNode()).setUserData("saaj.node", (Object)this, null);
        childEle.setParentElement(this);
        return childEle;
    }

    public SOAPElement addChildElement(String localName, String prefix, String uri) throws SOAPException {
        if (this.omSOAPBody.hasFault()) {
            throw new SOAPException("A SOAPFault has been already added to this SOAPBody");
        }
        SOAPBodyElementImpl childEle = uri == null || "".equals(uri) ? new SOAPBodyElementImpl((ElementImpl)this.getOwnerDocument().createElement(localName)) : new SOAPBodyElementImpl((ElementImpl)this.getOwnerDocument().createElementNS(uri, prefix + ":" + localName));
        childEle.element.setUserData("saaj.node", (Object)childEle, null);
        childEle.element.setNamespace(childEle.element.declareNamespace(uri, prefix));
        this.element.appendChild((org.w3c.dom.Node)childEle.element);
        ((NodeImpl)childEle.element.getParentNode()).setUserData("saaj.node", (Object)this, null);
        this.isBodyElementAdded = true;
        childEle.setParentElement(this);
        return childEle;
    }

    public javax.xml.soap.SOAPFault addFault() throws SOAPException {
        if (this.isBodyElementAdded) {
            throw new SOAPException("A SOAPBodyElement has been already added to this SOAPBody");
        }
        SOAP11FaultImpl fault = new SOAP11FaultImpl(this.omSOAPBody, (SOAPFactory)this.element.getOMFactory());
        SOAPFaultImpl saajSOAPFault = new SOAPFaultImpl((SOAPFault)fault);
        ((NodeImpl)this.omSOAPBody.getFault()).setUserData("saaj.node", (Object)saajSOAPFault, null);
        return saajSOAPFault;
    }

    public boolean hasFault() {
        return this.omSOAPBody.hasFault();
    }

    public javax.xml.soap.SOAPFault getFault() {
        if (this.omSOAPBody.hasFault()) {
            return (javax.xml.soap.SOAPFault)this.toSAAJNode((org.w3c.dom.Node)this.omSOAPBody.getFault());
        }
        return null;
    }

    public SOAPBodyElement addBodyElement(Name name) throws SOAPException {
        return (SOAPBodyElement)this.addChildElement(name);
    }

    public javax.xml.soap.SOAPFault addFault(Name faultCode, String faultString, Locale locale) throws SOAPException {
        SOAP11FaultImpl fault = new SOAP11FaultImpl(this.omSOAPBody, new Exception(faultString), (SOAPFactory)this.element.getOMFactory());
        SOAPFaultImpl faultImpl = new SOAPFaultImpl((SOAPFault)fault);
        faultImpl.setFaultCode(faultCode);
        if (locale != null) {
            faultImpl.setFaultString(faultString, locale);
        } else {
            faultImpl.setFaultString(faultString);
        }
        return faultImpl;
    }

    public javax.xml.soap.SOAPFault addFault(Name faultCode, String faultString) throws SOAPException {
        return this.addFault(faultCode, faultString, null);
    }

    public SOAPBodyElement addDocument(Document document) throws SOAPException {
        Element docEle = document.getDocumentElement();
        SOAPElement saajSOAPEle = (SOAPElement)this.toSAAJNode(docEle, this);
        SOAPBodyElementImpl bodyEle = new SOAPBodyElementImpl(((SOAPElementImpl)saajSOAPEle).element);
        this.addChildElement(bodyEle);
        return bodyEle;
    }

    private Node toSAAJNode(org.w3c.dom.Node node, SOAPElement parent) throws SOAPException {
        NamespaceImpl ns;
        String localname;
        if (node == null) {
            return null;
        }
        if (node instanceof org.w3c.dom.Text) {
            org.w3c.dom.Text domText = (org.w3c.dom.Text)node;
            return new TextImplEx(domText.getData(), parent);
        }
        if (node instanceof Comment) {
            Comment domText = (Comment)node;
            return new TextImplEx("<!--" + domText.getData() + "-->", parent);
        }
        Element domEle = (Element)node;
        int indexOfColon = domEle.getTagName().indexOf(":");
        if (indexOfColon != -1) {
            localname = domEle.getTagName().substring(indexOfColon + 1);
            ns = new NamespaceImpl(domEle.getNamespaceURI(), domEle.getTagName().substring(0, indexOfColon));
        } else {
            localname = domEle.getLocalName();
            ns = new NamespaceImpl(domEle.getNamespaceURI(), domEle.getPrefix());
        }
        ElementImpl eleImpl = new ElementImpl((DocumentImpl)this.getOwnerDocument(), localname, ns, this.element.getOMFactory());
        SOAPElementImpl saajEle = new SOAPElementImpl(eleImpl);
        saajEle.setParentElement(parent);
        NamedNodeMap domAttrs = domEle.getAttributes();
        for (int i = 0; i < domAttrs.getLength(); ++i) {
            org.w3c.dom.Node attrNode = domAttrs.item(i);
            saajEle.addAttribute(new PrefixedQName(attrNode.getNamespaceURI(), attrNode.getLocalName(), attrNode.getPrefix()), attrNode.getNodeValue());
        }
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childSAAJNode = this.toSAAJNode(childNodes.item(i), saajEle);
            if (childSAAJNode instanceof Text) {
                saajEle.addTextNode(childSAAJNode.getValue());
                continue;
            }
            saajEle.addChildElement((SOAPElement)childSAAJNode);
        }
        return saajEle;
    }

    public void detachNode() {
        this.detach();
    }

    public OMNode detach() {
        this.parentElement = null;
        return this.element.detach();
    }

    public Iterator getChildElements(Name name) {
        QName qName = new QName(name.getURI(), name.getLocalName());
        return this.getChildren(this.element.getChildrenWithName(qName));
    }

    public Iterator getChildElements() {
        return this.getChildren(this.element.getChildren());
    }

    public SOAPElement addTextNode(String text) throws SOAPException {
        throw new UnsupportedOperationException("Cannot add text node to SOAPBody");
    }

    private Iterator getChildren(Iterator childIter) {
        ArrayList<Node> childElements = new ArrayList<Node>();
        while (childIter.hasNext()) {
            org.w3c.dom.Node domNode = (org.w3c.dom.Node)childIter.next();
            Node saajNode = this.toSAAJNode(domNode);
            if (saajNode instanceof Text) {
                childElements.add(saajNode);
                continue;
            }
            if (!(saajNode instanceof SOAPBodyElement)) {
                if (!(domNode instanceof ElementImpl)) continue;
                if (this.omSOAPBody.hasFault()) {
                    SOAP11FaultImpl fault = new SOAP11FaultImpl(this.omSOAPBody, (SOAPFactory)this.element.getOMFactory());
                    SOAPFaultImpl saajSOAPFault = new SOAPFaultImpl((SOAPFault)fault);
                    ((NodeImpl)this.omSOAPBody.getFault()).setUserData("saaj.node", (Object)saajSOAPFault, null);
                    childElements.add(saajSOAPFault);
                    continue;
                }
                SOAPBodyElementImpl saajBodyEle = new SOAPBodyElementImpl((ElementImpl)domNode);
                ((NodeImpl)domNode).setUserData("saaj.node", (Object)saajBodyEle, null);
                childElements.add(saajBodyEle);
                continue;
            }
            childElements.add(saajNode);
        }
        return childElements.iterator();
    }
}

