/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.dm.muws.adv.impl;

import javax.xml.namespace.QName;
import org.apache.muse.core.AbstractCapability;
import org.apache.muse.core.Environment;
import org.apache.muse.core.Resource;
import org.apache.muse.core.ResourceManager;
import org.apache.muse.core.ResourceManagerListener;
import org.apache.muse.util.xml.XmlSerializable;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.dm.muws.MuwsConstants;
import org.apache.muse.ws.dm.muws.adv.Advertisement;
import org.apache.muse.ws.dm.muws.events.Component;
import org.apache.muse.ws.dm.muws.events.ComponentAddress;
import org.apache.muse.ws.dm.muws.events.ManagementEvent;
import org.apache.muse.ws.dm.muws.events.Situation;
import org.apache.muse.ws.dm.muws.events.WefConstants;
import org.apache.muse.ws.dm.muws.events.WefFactory;
import org.apache.muse.ws.dm.muws.events.impl.SimpleWefFactory;
import org.apache.muse.ws.notification.Filter;
import org.apache.muse.ws.notification.NotificationProducer;
import org.apache.muse.ws.notification.impl.TopicFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractAdvertisement
extends AbstractCapability
implements Advertisement,
ResourceManagerListener {
    private static final String _CONSUMER_EPR_PARAM = "initial-consumer-reference";

    protected WefFactory createWefFactory() {
        return new SimpleWefFactory();
    }

    public void initializeCompleted() throws SoapFault {
        super.initializeCompleted();
        Resource resource = this.getResource();
        ResourceManager manager = resource.getResourceManager();
        manager.addListener((ResourceManagerListener)this);
        NotificationProducer wsn = (NotificationProducer)resource.getCapability("http://docs.oasis-open.org/wsn/bw-2/NotificationProducer");
        wsn.addTopic(MuwsConstants.ADV_ME_CREATION_TOPIC);
        wsn.addTopic(MuwsConstants.ADV_ME_DESTRUCTION_TOPIC);
        this.subscribeInitialConsumer();
    }

    protected abstract boolean isAdvertised(EndpointReference var1);

    public void resourceAdded(EndpointReference epr, Resource resource) throws SoapFault {
        if (!this.isAdvertised(epr)) {
            return;
        }
        Element payload = XmlUtils.createElement((QName)MuwsConstants.MANAGEABILITY_EPR_QNAME, (Object)epr.toXML());
        this.sendMessage(epr, MuwsConstants.ADV_ME_CREATION_TOPIC, WefConstants.CREATE_SITUATION_QNAME, payload);
    }

    public void resourceRemoved(EndpointReference epr) throws SoapFault {
        if (!this.isAdvertised(epr)) {
            return;
        }
        Element payload = XmlUtils.createElement((QName)MuwsConstants.DESTROY_NOTIFICATION_QNAME);
        this.sendMessage(epr, MuwsConstants.ADV_ME_DESTRUCTION_TOPIC, WefConstants.DESTROY_SITUATION_QNAME, payload);
        Resource advertiser = this.getResource();
        if (advertiser.hasBeenShutdown()) {
            advertiser.getResourceManager().removeListener((ResourceManagerListener)this);
        }
    }

    protected void sendMessage(EndpointReference sourceEPR, QName topicName, QName situationCategory, Element payload) throws SoapFault {
        Resource advertiser = this.getResource();
        WefFactory factory = this.createWefFactory();
        ManagementEvent event = factory.createEvent();
        event.addExtendedElement(payload);
        Component source = factory.createComponent();
        source.setName(WefConstants.SOURCE_COMP_QNAME);
        ComponentAddress address = factory.createComponentAddress((XmlSerializable)sourceEPR);
        source.setAddress(address);
        event.setSource(source);
        Component reporter = factory.createComponent();
        reporter.setName(WefConstants.REPORTER_COMP_QNAME);
        address = factory.createComponentAddress((XmlSerializable)advertiser.getEndpointReference());
        reporter.setAddress(address);
        event.setReporter(reporter);
        Situation situation = factory.createSituation();
        situation.setCategoryType(situationCategory);
        event.setSituation(situation);
        NotificationProducer wsn = (NotificationProducer)advertiser.getCapability("http://docs.oasis-open.org/wsn/bw-2/NotificationProducer");
        wsn.publish(topicName, event.toXML());
    }

    protected void subscribeInitialConsumer() throws SoapFault {
        String fileName = this.getInitializationParameter(_CONSUMER_EPR_PARAM);
        if (fileName != null) {
            Environment env = this.getResource().getEnvironment();
            Document eprDoc = env.getDocument(fileName);
            Element eprXML = XmlUtils.getFirstElement((Node)eprDoc);
            EndpointReference epr = new EndpointReference(eprXML);
            NotificationProducer wsn = (NotificationProducer)this.getResource().getCapability("http://docs.oasis-open.org/wsn/bw-2/NotificationProducer");
            wsn.subscribe(epr, (Filter)new TopicFilter(MuwsConstants.ADV_ME_CREATION_TOPIC), null, null);
            wsn.subscribe(epr, (Filter)new TopicFilter(MuwsConstants.ADV_ME_DESTRUCTION_TOPIC), null, null);
        }
    }
}

