/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.dm.muws.remote;

import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.muse.core.Environment;
import org.apache.muse.util.xml.XsdUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.soap.SoapClient;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.resource.properties.impl.WsrpUtils;
import org.apache.muse.ws.resource.remote.WsResourceClient;
import org.w3c.dom.Element;

public class MetricsClient
extends WsResourceClient {
    public MetricsClient(EndpointReference destination) {
        super(destination);
    }

    public MetricsClient(EndpointReference destination, EndpointReference source) {
        super(destination, source);
    }

    public MetricsClient(EndpointReference destination, EndpointReference source, Environment environment) {
        super(destination, source, environment);
    }

    public MetricsClient(EndpointReference destination, EndpointReference source, SoapClient soapClient) {
        super(destination, source, soapClient);
    }

    public Object getPropertyAsObjectAndMetrics(QName qname, Class type, Map metrics) throws SoapFault {
        Element[] properties = this.getResourcePropertyAndMetrics(qname, metrics);
        return WsrpUtils.convertToObjects((Element[])properties, (Class)type);
    }

    public Element[] getResourcePropertyAndMetrics(QName qname, Map metrics) throws SoapFault {
        Element[] properties = super.getResourceProperty(qname);
        if (properties.length > 0) {
            String resetAt = properties[0].getAttribute("ResetAt");
            String lastUpdated = properties[0].getAttribute("LastUpdated");
            String duration = properties[0].getAttribute("Duration");
            try {
                if (resetAt != null && resetAt.length() > 0) {
                    metrics.put("ResetAt", XsdUtils.getLocalTime((String)resetAt));
                }
                if (lastUpdated != null && lastUpdated.length() > 0) {
                    metrics.put("LastUpdated", XsdUtils.getLocalTime((String)lastUpdated));
                }
            }
            catch (Throwable error) {
                throw new SoapFault(error.getMessage(), error);
            }
            if (duration != null && duration.length() > 0) {
                metrics.put("Duration", duration);
            }
        }
        return properties;
    }
}

