/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.dm.muws.impl;

import javax.xml.namespace.QName;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.dm.muws.Correlation;
import org.apache.muse.ws.dm.muws.MuwsConstants;
import org.apache.muse.ws.resource.WsResource;
import org.apache.muse.ws.resource.remote.WsResourceClient;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XPathCorrelation
implements Correlation {
    private static Messages _MESSAGES = MessagesFactory.get((Object)(class$org$apache$muse$ws$dm$muws$impl$XPathCorrelation == null ? (class$org$apache$muse$ws$dm$muws$impl$XPathCorrelation = XPathCorrelation.class$("org.apache.muse.ws.dm.muws.impl.XPathCorrelation")) : class$org$apache$muse$ws$dm$muws$impl$XPathCorrelation));
    private boolean _hasNegativeAssertion = false;
    private WsResource _resource = null;
    private String _xpath = null;
    static /* synthetic */ Class class$org$apache$muse$ws$dm$muws$impl$XPathCorrelation;

    public XPathCorrelation(WsResource resource, Element xml) {
        if (resource == null) {
            throw new NullPointerException(_MESSAGES.get("NullOwner"));
        }
        if (xml == null) {
            throw new NullPointerException(_MESSAGES.get("NullCPElement"));
        }
        this._resource = resource;
        this._xpath = XmlUtils.extractText((Element)xml);
        if (this._xpath == null) {
            throw new NullPointerException(_MESSAGES.get("NullXPath"));
        }
        String negative = xml.getAttribute("NegativeAssertionPossible");
        if (negative != null && negative.length() > 0) {
            this._hasNegativeAssertion = Boolean.valueOf(negative);
        }
    }

    public XPathCorrelation(WsResource resource, String xpath) {
        this(resource, xpath, false);
    }

    public XPathCorrelation(WsResource resource, String xpath, boolean negativeAssertion) {
        if (resource == null) {
            throw new NullPointerException(_MESSAGES.get("NullOwner"));
        }
        if (xpath == null) {
            throw new NullPointerException(_MESSAGES.get("NullXPath"));
        }
        this._resource = resource;
        this._xpath = xpath;
        this._hasNegativeAssertion = negativeAssertion;
    }

    public String getDialect() {
        return "http://www.w3.org/TR/1999/REC-xpath-19991116";
    }

    public WsResource getWsResource() {
        return this._resource;
    }

    public String getXPath() {
        return this._xpath;
    }

    public boolean hasNegativeAssertion() {
        return this._hasNegativeAssertion;
    }

    public boolean matches(EndpointReference epr) throws SoapFault {
        if (epr == null) {
            throw new NullPointerException(_MESSAGES.get("NullRemoteResource"));
        }
        WsResourceClient resource = new WsResourceClient(epr);
        String dialect = "http://www.w3.org/TR/1999/REC-xpath-19991116";
        Node[] results = resource.queryResourceProperties(this._xpath, dialect);
        if (results.length == 0) {
            return false;
        }
        if (results.length > 1) {
            return true;
        }
        String text = results[0].getNodeValue();
        return text == null || !text.equalsIgnoreCase("false");
    }

    public void setXPath(String xpath) {
        if (xpath == null) {
            throw new NullPointerException(_MESSAGES.get("NullXPath"));
        }
        this._xpath = xpath;
    }

    public Element toXML() {
        return this.toXML(XmlUtils.EMPTY_DOC);
    }

    public Element toXML(Document doc) {
        if (doc == null) {
            throw new NullPointerException(_MESSAGES.get("NullDocument"));
        }
        QName qname = MuwsConstants.CORRELATABLE_QNAME;
        Element root = XmlUtils.createElement((Document)doc, (QName)qname, (Object)this.getXPath());
        root.setAttribute("Dialect", this.getDialect());
        String negative = Boolean.toString(this.hasNegativeAssertion());
        root.setAttribute("NegativeAssertionPossible", negative);
        return root;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

