/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.dm.muws.impl;

import javax.xml.namespace.QName;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.dm.muws.Identity;
import org.apache.muse.ws.dm.muws.MuwsConstants;
import org.apache.muse.ws.dm.muws.Participant;
import org.apache.muse.ws.resource.WsResource;
import org.apache.muse.ws.resource.basefaults.BaseFault;
import org.apache.muse.ws.resource.basefaults.WsbfUtils;
import org.apache.muse.ws.resource.ext.faults.InvalidMessageFormatFault;
import org.apache.muse.ws.resource.remote.WsResourceClient;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SimpleParticipant
implements Participant {
    private static Messages _MESSAGES = MessagesFactory.get((Object)(class$org$apache$muse$ws$dm$muws$impl$SimpleParticipant == null ? (class$org$apache$muse$ws$dm$muws$impl$SimpleParticipant = SimpleParticipant.class$("org.apache.muse.ws.dm.muws.impl.SimpleParticipant")) : class$org$apache$muse$ws$dm$muws$impl$SimpleParticipant));
    private EndpointReference _resourceEPR = null;
    private String _resourceID = null;
    public String _role = null;
    static /* synthetic */ Class class$org$apache$muse$ws$dm$muws$impl$SimpleParticipant;
    static /* synthetic */ Class class$java$lang$String;

    private static String getResourceId(WsResource resource) throws BaseFault {
        Identity id = (Identity)resource.getCapability("http://docs.oasis-open.org/wsdm/muws/capabilities/Identity");
        return id == null ? null : id.getResourceId();
    }

    private static String getResourceId(WsResourceClient resource) throws BaseFault {
        try {
            String[] results = (String[])resource.getPropertyAsObject(MuwsConstants.RESOURCE_ID_QNAME, class$java$lang$String == null ? (class$java$lang$String = SimpleParticipant.class$("java.lang.String")) : class$java$lang$String);
            if (results.length == 0) {
                return null;
            }
            return results[0];
        }
        catch (SoapFault error) {
            throw WsbfUtils.convertToFault((Throwable)error);
        }
    }

    public SimpleParticipant(Element xml) throws BaseFault {
        if (xml == null) {
            throw new NullPointerException(_MESSAGES.get("NullParticipantElement"));
        }
        Element eprXML = XmlUtils.getElement((Node)xml, (QName)MuwsConstants.MANAGEABILITY_EPR_QNAME);
        if (eprXML == null) {
            throw new InvalidMessageFormatFault(_MESSAGES.get("NoParticipantEPR"));
        }
        try {
            this._resourceEPR = new EndpointReference(eprXML);
        }
        catch (SoapFault error) {
            throw new InvalidMessageFormatFault((Throwable)error);
        }
        this._resourceID = XmlUtils.getElementText((Node)xml, (QName)MuwsConstants.RESOURCE_ID_QNAME);
        if (this._resourceID == null) {
            throw new InvalidMessageFormatFault(_MESSAGES.get("NoParticipantID"));
        }
        this._role = XmlUtils.getElementText((Node)xml, (QName)MuwsConstants.ROLE_QNAME);
        if (this._role == null) {
            throw new InvalidMessageFormatFault(_MESSAGES.get("NoParticipantRole"));
        }
    }

    public SimpleParticipant(EndpointReference resourceEPR, String resourceID, String role) {
        if (resourceEPR == null) {
            throw new NullPointerException(_MESSAGES.get("NullParticipantEPR"));
        }
        if (resourceID == null) {
            throw new NullPointerException(_MESSAGES.get("NullParticipantID"));
        }
        if (role == null) {
            throw new NullPointerException(_MESSAGES.get("NullParticipantRole"));
        }
        this._resourceEPR = resourceEPR;
        this._resourceID = resourceID;
        this._role = role;
    }

    public SimpleParticipant(WsResource resource, String role) throws BaseFault {
        if (resource == null) {
            throw new NullPointerException(_MESSAGES.get("NullParticipantResource"));
        }
        if (role == null) {
            throw new NullPointerException(_MESSAGES.get("NullParticipantRole"));
        }
        this._resourceEPR = resource.getEndpointReference();
        this._resourceID = SimpleParticipant.getResourceId(resource);
        this._role = role;
    }

    public SimpleParticipant(WsResourceClient remote, String role) throws BaseFault {
        if (remote == null) {
            throw new NullPointerException(_MESSAGES.get("NullParticipantResource"));
        }
        if (role == null) {
            throw new NullPointerException(_MESSAGES.get("NullParticipantRole"));
        }
        this._resourceEPR = remote.getEndpointReference();
        this._resourceID = SimpleParticipant.getResourceId(remote);
        this._role = role;
    }

    public EndpointReference getManageabilityReference() {
        return this._resourceEPR;
    }

    public String getResourceId() {
        return this._resourceID;
    }

    public String getRole() {
        return this._role;
    }

    public Element toXML() {
        return this.toXML(XmlUtils.EMPTY_DOC);
    }

    public Element toXML(Document doc) {
        if (doc == null) {
            throw new NullPointerException(_MESSAGES.get("NullDocument"));
        }
        Element root = XmlUtils.createElement((Document)doc, (QName)MuwsConstants.PARTICIPANT_QNAME);
        Element eprXML = this.getManageabilityReference().toXML();
        XmlUtils.setElement((Element)root, (QName)MuwsConstants.MANAGEABILITY_EPR_QNAME, (Object)eprXML);
        String resourceID = this.getResourceId();
        if (resourceID != null) {
            XmlUtils.setElement((Element)root, (QName)MuwsConstants.RESOURCE_ID_QNAME, (Object)resourceID);
        }
        XmlUtils.setElement((Element)root, (QName)MuwsConstants.ROLE_QNAME, (Object)this.getRole());
        return root;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

