/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.dm.muws.impl;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.dm.muws.Correlation;
import org.apache.muse.ws.dm.muws.Match;
import org.apache.muse.ws.dm.muws.MuwsConstants;
import org.apache.muse.ws.dm.muws.impl.AllMatch;
import org.apache.muse.ws.resource.WsResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MatchCorrelation
implements Correlation,
Match {
    private static Messages _MESSAGES = MessagesFactory.get((Object)(class$org$apache$muse$ws$dm$muws$impl$MatchCorrelation == null ? (class$org$apache$muse$ws$dm$muws$impl$MatchCorrelation = MatchCorrelation.class$("org.apache.muse.ws.dm.muws.impl.MatchCorrelation")) : class$org$apache$muse$ws$dm$muws$impl$MatchCorrelation));
    private boolean _hasNegativeAssertion = false;
    private AllMatch _root = null;
    static /* synthetic */ Class class$org$apache$muse$ws$dm$muws$impl$MatchCorrelation;

    public MatchCorrelation(WsResource resource) {
        this(resource, false);
    }

    public MatchCorrelation(WsResource resource, boolean negativeAssertion) {
        if (resource == null) {
            throw new NullPointerException(_MESSAGES.get("NullOwner"));
        }
        this._root = new AllMatch(resource);
        this._hasNegativeAssertion = negativeAssertion;
    }

    public MatchCorrelation(WsResource resource, Element xml) {
        if (resource == null) {
            throw new NullPointerException(_MESSAGES.get("NullOwner"));
        }
        if (xml == null) {
            throw new NullPointerException(_MESSAGES.get("NullCPElement"));
        }
        this._root = new AllMatch(resource, xml);
        String negative = xml.getAttribute("NegativeAssertionPossible");
        if (negative != null && negative.length() > 0) {
            this._hasNegativeAssertion = Boolean.valueOf(negative);
        }
    }

    public void addMatch(Match child) {
        if (child == null) {
            throw new NullPointerException(_MESSAGES.get("NullMatch"));
        }
        this._root.addMatch(child);
    }

    public String getDialect() {
        return "http://docs.oasis-open.org/wsdm/2004/12/pbm";
    }

    public List getMatches() {
        return this._root.getMatches();
    }

    public WsResource getWsResource() {
        return this._root.getWsResource();
    }

    public boolean hasNegativeAssertion() {
        return this._hasNegativeAssertion;
    }

    public boolean matches(EndpointReference epr) throws SoapFault {
        if (epr == null) {
            throw new NullPointerException(_MESSAGES.get("NullRemoteResource"));
        }
        return this._root.matches(epr);
    }

    public void removeMatch(Match child) {
        if (child == null) {
            throw new NullPointerException(_MESSAGES.get("NullMatch"));
        }
        this._root.removeMatch(child);
    }

    public Element toXML() {
        return this.toXML(XmlUtils.EMPTY_DOC);
    }

    public Element toXML(Document doc) {
        if (doc == null) {
            throw new NullPointerException(_MESSAGES.get("NullDocument"));
        }
        QName qname = MuwsConstants.CORRELATABLE_QNAME;
        Element rootXML = XmlUtils.createElement((Document)doc, (QName)qname);
        rootXML.setAttribute("Dialect", this.getDialect());
        String negative = Boolean.toString(this.hasNegativeAssertion());
        rootXML.setAttribute("NegativeAssertionPossible", negative);
        Element matchXML = this._root.toXML(doc);
        return (Element)XmlUtils.moveSubTree((Node)matchXML, (Node)rootXML);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

