/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.util.messages;

import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.muse.util.StringUtils;

public class Messages {
    private static final String _PLACE_HOLDER = "XXX";
    private Object[] _EMPTY = new Object[0];
    private ResourceBundle _messages = null;

    public Messages(String bundleName) {
        this._messages = ResourceBundle.getBundle(bundleName);
    }

    public Messages(String bundleName, ClassLoader loader) {
        this._messages = ResourceBundle.getBundle(bundleName, Locale.getDefault(), loader);
    }

    public String get(String name) {
        return this.get(name, this._EMPTY);
    }

    public String get(String name, boolean includeID) {
        return this.get(name, this._EMPTY, includeID);
    }

    public String get(String name, Object[] filler) {
        return this.get(name, filler, true);
    }

    public String get(String name, Object[] filler, boolean includeID) {
        String[] fillerStrings = new String[filler.length];
        for (int n = 0; n < filler.length; ++n) {
            fillerStrings[n] = String.valueOf(filler[n]);
            fillerStrings[n] = fillerStrings[n].replace('\\', '/');
        }
        String message = this._messages.getString(name);
        StringBuffer buffer = new StringBuffer(message.length() + name.length() + 512);
        if (includeID) {
            buffer.append("[ID = '");
            buffer.append(name);
            buffer.append("'] ");
        }
        for (int n = 0; n < fillerStrings.length; ++n) {
            message = StringUtils.replaceFirst(message, _PLACE_HOLDER, fillerStrings[n]);
        }
        buffer.append(message);
        return buffer.toString();
    }
}

