/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.tools.generator.util;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.muse.tools.generator.util.Capability;
import org.apache.muse.tools.generator.util.ConfigurationData;
import org.apache.muse.util.FileUtils;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.resource.metadata.MetadataDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SubscriptionManagerHelper {
    public static final String SUBSCRIPTION_MANAGER_DIR = "/resources/common/subscription-manager";
    public static final String SUBSCRIPTION_MANAGER_RESOURCE_TYPE = "/resources/common/subscription-manager/muse.xml";
    public static final String SUBSCRIPTION_MANAGER_WSDL = "/resources/common/subscription-manager/SubscriptionManager.wsdl";
    static /* synthetic */ Class class$org$apache$muse$ws$resource$properties$get$impl$SimpleGetCapability;
    static /* synthetic */ Class class$org$apache$muse$ws$resource$lifetime$impl$SimpleImmediateTermination;
    static /* synthetic */ Class class$org$apache$muse$ws$resource$lifetime$impl$SimpleScheduledTermination;
    static /* synthetic */ Class class$org$apache$muse$ws$notification$impl$SimpleSubscriptionManager;
    static /* synthetic */ Class class$org$apache$muse$tools$generator$util$SubscriptionManagerHelper;

    public static ConfigurationData addSubscriptionManager(ConfigurationData data) {
        if (SubscriptionManagerHelper.needsSubscriptionManager(data)) {
            SubscriptionManagerHelper.modifyDescriptorDocument(data);
            SubscriptionManagerHelper.addSubscriptionManagerCapabilities(data);
            SubscriptionManagerHelper.addSubscriptionManagerWsdl(data);
            SubscriptionManagerHelper.addSubscriptionManagerMetadata(data);
        }
        return data;
    }

    private static void addSubscriptionManagerMetadata(ConfigurationData data) {
        MetadataDescriptor[] oldMetadatas = (MetadataDescriptor[])data.getParameter("metadata_list");
        MetadataDescriptor[] newMetadatas = new MetadataDescriptor[oldMetadatas.length + 1];
        System.arraycopy(oldMetadatas, 0, newMetadatas, 0, oldMetadatas.length);
        newMetadatas[oldMetadatas.length] = null;
        data.addParameter("metadata_list", newMetadatas);
    }

    private static void addSubscriptionManagerCapabilities(ConfigurationData data) {
        Map[] oldCaps = (Map[])data.getParameter("capabilities_map_list");
        Map[] newCaps = new Map[oldCaps.length + 1];
        System.arraycopy(oldCaps, 0, newCaps, 0, oldCaps.length);
        HashMap<String, Capability> subMgrCaps = new HashMap<String, Capability>();
        Capability wsrpGet = new Capability("http://docs.oasis-open.org/wsrf/rpw-2/Get");
        wsrpGet.setBuiltIn(true);
        wsrpGet.setImplementingClass((class$org$apache$muse$ws$resource$properties$get$impl$SimpleGetCapability == null ? (class$org$apache$muse$ws$resource$properties$get$impl$SimpleGetCapability = SubscriptionManagerHelper.class$("org.apache.muse.ws.resource.properties.get.impl.SimpleGetCapability")) : class$org$apache$muse$ws$resource$properties$get$impl$SimpleGetCapability).getName());
        Capability wsrlImmediate = new Capability("http://docs.oasis-open.org/wsrf/rlw-2/ImmediateResourceTermination");
        wsrlImmediate.setBuiltIn(true);
        wsrlImmediate.setImplementingClass((class$org$apache$muse$ws$resource$lifetime$impl$SimpleImmediateTermination == null ? (class$org$apache$muse$ws$resource$lifetime$impl$SimpleImmediateTermination = SubscriptionManagerHelper.class$("org.apache.muse.ws.resource.lifetime.impl.SimpleImmediateTermination")) : class$org$apache$muse$ws$resource$lifetime$impl$SimpleImmediateTermination).getName());
        Capability wsrlScheduled = new Capability("http://docs.oasis-open.org/wsrf/rlw-2/ScheduledResourceTermination");
        wsrlScheduled.setBuiltIn(true);
        wsrlScheduled.setImplementingClass((class$org$apache$muse$ws$resource$lifetime$impl$SimpleScheduledTermination == null ? (class$org$apache$muse$ws$resource$lifetime$impl$SimpleScheduledTermination = SubscriptionManagerHelper.class$("org.apache.muse.ws.resource.lifetime.impl.SimpleScheduledTermination")) : class$org$apache$muse$ws$resource$lifetime$impl$SimpleScheduledTermination).getName());
        Capability subMgr = new Capability("http://docs.oasis-open.org/wsn/bw-2/SubscriptionManager");
        subMgr.setBuiltIn(true);
        subMgr.setImplementingClass((class$org$apache$muse$ws$notification$impl$SimpleSubscriptionManager == null ? (class$org$apache$muse$ws$notification$impl$SimpleSubscriptionManager = SubscriptionManagerHelper.class$("org.apache.muse.ws.notification.impl.SimpleSubscriptionManager")) : class$org$apache$muse$ws$notification$impl$SimpleSubscriptionManager).getName());
        subMgrCaps.put(wsrpGet.getURI(), wsrpGet);
        subMgrCaps.put(wsrlImmediate.getURI(), wsrlImmediate);
        subMgrCaps.put(wsrlScheduled.getURI(), wsrlScheduled);
        subMgrCaps.put(subMgr.getURI(), subMgr);
        newCaps[oldCaps.length] = subMgrCaps;
        data.addParameter("capabilities_map_list", newCaps);
    }

    private static void addSubscriptionManagerWsdl(ConfigurationData data) {
        Document[] oldWsdls = (Document[])data.getParameter("wsdl_documents");
        Document[] newWsdls = new Document[oldWsdls.length + 1];
        System.arraycopy(oldWsdls, 0, newWsdls, 0, oldWsdls.length);
        newWsdls[oldWsdls.length] = SubscriptionManagerHelper.loadDocument(SUBSCRIPTION_MANAGER_WSDL);
        data.addParameter("wsdl_documents", newWsdls);
    }

    private static void modifyDescriptorDocument(ConfigurationData data) {
        Document subscriptionType = SubscriptionManagerHelper.loadDocument(SUBSCRIPTION_MANAGER_RESOURCE_TYPE);
        Document descriptorDocument = (Document)data.getParameter("descriptor_document");
        Node importedSubscriptionType = descriptorDocument.importNode(subscriptionType.getDocumentElement(), true);
        SubscriptionManagerHelper.insertAfterLastResourceType(descriptorDocument, importedSubscriptionType);
    }

    private static void insertAfterLastResourceType(Document descriptorDocument, Node importedSubscriptionType) {
        Element nodeAfterLastResourceType = SubscriptionManagerHelper.getNodeAfterLastResourceType(descriptorDocument);
        if (nodeAfterLastResourceType == null) {
            descriptorDocument.getDocumentElement().appendChild(importedSubscriptionType);
        } else {
            descriptorDocument.getDocumentElement().insertBefore(nodeAfterLastResourceType, importedSubscriptionType);
        }
    }

    private static Element getNodeAfterLastResourceType(Document descriptorDocument) {
        Element[] elements = XmlUtils.getAllElements((Node)descriptorDocument.getDocumentElement());
        for (Node last = elements[elements.length - 1].getNextSibling(); last != null; last = last.getNextSibling()) {
            if (!(last instanceof Element)) continue;
            return (Element)last;
        }
        return null;
    }

    private static Document loadDocument(String path) {
        InputStream inputStream = FileUtils.loadFromContext((Class)(class$org$apache$muse$tools$generator$util$SubscriptionManagerHelper == null ? (class$org$apache$muse$tools$generator$util$SubscriptionManagerHelper = SubscriptionManagerHelper.class$("org.apache.muse.tools.generator.util.SubscriptionManagerHelper")) : class$org$apache$muse$tools$generator$util$SubscriptionManagerHelper), (String)path);
        try {
            return XmlUtils.createDocument((InputStream)inputStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static boolean needsSubscriptionManager(ConfigurationData data) {
        Map[] capabilityMaps = (Map[])data.getParameter("capabilities_map_list");
        boolean hasNotificationProducer = false;
        boolean hasSubscriptionManager = false;
        for (int j = 0; j < capabilityMaps.length; ++j) {
            Iterator i = capabilityMaps[j].values().iterator();
            while (i.hasNext()) {
                Capability capability = (Capability)i.next();
                String uri = capability.getURI();
                if (uri.equals("http://docs.oasis-open.org/wsn/bw-2/SubscriptionManager")) {
                    hasSubscriptionManager = true;
                }
                if (!uri.equals("http://docs.oasis-open.org/wsn/bw-2/NotificationProducer")) continue;
                hasNotificationProducer = true;
            }
        }
        return hasNotificationProducer && !hasSubscriptionManager;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

