/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.tools.generator.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.muse.tools.generator.util.Capability;
import org.apache.muse.tools.inspector.JavaMethod;
import org.apache.muse.util.xml.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ServicesDescriptorHelper {
    private static final QName SERVICE_GROUP_QNAME = new QName("serviceGroup");
    private static final QName SERVICE_QNAME = new QName("service");
    private static final QName OPERATION_QNAME = new QName("operation");
    String AXIS2_ISOLATION_LAYER = "org.apache.muse.core.platform.axis2.AxisIsolationLayer";
    private static final QName ACTION_MAPPING = new QName("actionMapping");
    private static final String NAME_ATTRIBUTE = "name";
    private static final String SERVICE_CLASS = "ServiceClass";
    private static final QName PARAMETER_QNAME = new QName("parameter");
    private static final String LOCKED_ATTRIBUTE = "locked";
    private static final String HANDLE_REQUEST = "handleRequest";
    private static final String MESSAGE_RECV_CLASS = "org.apache.axis2.receivers.RawXMLINOutMessageReceiver";
    private static final QName MESSAGE_RECV_QNAME = new QName("messageReceiver");
    private static final String CLASS_ATTRIBUTE = "class";
    private Document _servicesDocument;
    private Element _serviceGroupElement;
    private Map _serviceOperations = new HashMap();

    public ServicesDescriptorHelper() {
        this._servicesDocument = XmlUtils.createDocument();
        this._serviceGroupElement = XmlUtils.createElement((Document)this._servicesDocument, (QName)SERVICE_GROUP_QNAME);
        this._servicesDocument.appendChild(this._serviceGroupElement);
    }

    private String makeActionURI(Capability capability, JavaMethod method) {
        String actionURI = method.getActionURI();
        if (actionURI != null) {
            return actionURI;
        }
        String name = method.getName().getLocalPart();
        name = name.substring(0, 1).toUpperCase() + name.substring(1);
        return capability.getURI() + "/" + name;
    }

    public void addActionMappings(Capability capability, String serviceName) {
        Element operationElement = (Element)this._serviceOperations.get(serviceName);
        Iterator j = capability.getOperations().iterator();
        while (j.hasNext()) {
            JavaMethod method = (JavaMethod)j.next();
            Element actionMapping = XmlUtils.createElement((Document)this._servicesDocument, (QName)ACTION_MAPPING);
            XmlUtils.setElementText((Element)actionMapping, (String)this.makeActionURI(capability, method));
            operationElement.appendChild(actionMapping);
        }
    }

    public Node getDocument() {
        return this._servicesDocument;
    }

    public void createService(String serviceName) {
        Element serviceElement = XmlUtils.createElement((Document)this._servicesDocument, (QName)SERVICE_QNAME);
        this.setName(serviceElement, serviceName);
        Element parameter = this.createParameter(SERVICE_CLASS, this.AXIS2_ISOLATION_LAYER, false);
        serviceElement.appendChild(parameter);
        Element operation = this.createOperation(HANDLE_REQUEST);
        serviceElement.appendChild(operation);
        this._serviceOperations.put(serviceName, operation);
        this._serviceGroupElement.appendChild(serviceElement);
    }

    private Element createOperation(String name) {
        Element operationElement = XmlUtils.createElement((Document)this._servicesDocument, (QName)OPERATION_QNAME);
        operationElement.setAttribute(NAME_ATTRIBUTE, name);
        Element messageReceiver = this.createMessageReceiver(MESSAGE_RECV_CLASS);
        operationElement.appendChild(messageReceiver);
        return operationElement;
    }

    private Element createMessageReceiver(String recvClass) {
        Element messageRecvElement = XmlUtils.createElement((Document)this._servicesDocument, (QName)MESSAGE_RECV_QNAME);
        messageRecvElement.setAttribute(CLASS_ATTRIBUTE, recvClass);
        return messageRecvElement;
    }

    private Element createParameter(String name, String value, boolean locked) {
        Element parameterElement = XmlUtils.createElement((Document)this._servicesDocument, (QName)PARAMETER_QNAME);
        parameterElement.setAttribute(NAME_ATTRIBUTE, name);
        parameterElement.setAttribute(LOCKED_ATTRIBUTE, String.valueOf(locked));
        XmlUtils.setElementText((Element)parameterElement, (String)value);
        return parameterElement;
    }

    private void setName(Element serviceElement, String serviceName) {
        serviceElement.setAttribute(NAME_ATTRIBUTE, serviceName);
    }
}

