/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.tools.generator.synthesizer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.muse.tools.generator.synthesizer.AbstractSynthesizer;
import org.apache.muse.tools.generator.synthesizer.ClassInfo;
import org.apache.muse.tools.generator.util.Capability;
import org.apache.muse.tools.generator.util.ConfigurationData;
import org.apache.muse.tools.generator.util.ConfigurationDataDescriptor;
import org.apache.muse.tools.inspector.JavaMethod;
import org.apache.muse.tools.inspector.JavaProperty;

public class ServerInterfaceSynthesizer
extends AbstractSynthesizer {
    static ConfigurationDataDescriptor[] REQUIRED_PARAMETERS = new ConfigurationDataDescriptor[]{ConfigurationData.CAPABILITIES_MAP_LIST_CONFIGURATION};
    protected StringBuffer _headerCode;
    protected StringBuffer _bodyCode;
    protected String _className;
    protected Set _importSet;
    private Map[] _capabilityMaps;
    private Set[] _ignoreSets;
    private Map[] _filesMaps;
    static /* synthetic */ Class class$org$apache$muse$ws$resource$impl$AbstractWsResourceCapability;
    static /* synthetic */ Class class$org$apache$muse$core$AbstractCapability;

    public ConfigurationData synthesize(ConfigurationData configuration) throws Exception {
        ConfigurationData.checkConfiguration(this, configuration);
        this.loadParameters(configuration);
        for (int i = 0; i < this._capabilityMaps.length; ++i) {
            Map capabilities = this._capabilityMaps[i];
            if (this._filesMaps[i] == null) {
                this._filesMaps[i] = new HashMap();
            }
            if (this._ignoreSets[i] == null) {
                this._ignoreSets[i] = new HashSet();
            }
            Iterator j = capabilities.values().iterator();
            while (j.hasNext()) {
                Capability capability = (Capability)j.next();
                if (capability.isBuiltIn()) continue;
                this.generateCapability(capability, this._filesMaps[i], this._ignoreSets[i]);
            }
        }
        ConfigurationData resultData = (ConfigurationData)configuration.clone();
        resultData.addParameter("files_map_list", this._filesMaps);
        resultData.addParameter("ignore_sets", this._ignoreSets);
        return resultData;
    }

    private void loadParameters(ConfigurationData configuration) {
        this._capabilityMaps = (Map[])configuration.getParameter("capabilities_map_list");
        this._ignoreSets = (Set[])configuration.getParameter("ignore_sets");
        this._filesMaps = (Map[])configuration.getParameter("files_map_list");
        if (this._filesMaps == null) {
            this._filesMaps = new HashMap[this._capabilityMaps.length];
        }
        if (this._ignoreSets == null) {
            this._ignoreSets = new HashSet[this._capabilityMaps.length];
        }
    }

    protected void generateCapability(Capability capability, Map files, Set ignoreSet) {
        if (capability.isEmpty()) {
            return;
        }
        ClassInfo classInfo = new ClassInfo(capability);
        String className = this.generateClassName("I", capability);
        this.initializeCode(className, classInfo);
        this.generateNSDeclarations(classInfo, this._bodyCode);
        this.generatePropertyOperations(classInfo, this._bodyCode);
        this.generateOperations(classInfo, this._bodyCode);
        classInfo.addImports(this._importSet);
        String classFileName = this.createFileName(className);
        files.put(classFileName, this.generateCombinedCode(classInfo));
    }

    protected String generateCombinedCode(ClassInfo classInfo) {
        this.endHeaderCode(classInfo);
        this.endBodyCode();
        StringBuffer code = new StringBuffer();
        code.append(this._headerCode);
        code.append(this._bodyCode);
        return code.append(this.generateFooterCode()).toString();
    }

    protected void endBodyCode() {
    }

    protected void endHeaderCode(ClassInfo classInfo) {
        this.generateImports(classInfo, this._headerCode);
        this.generateClassDef(this._className, true, this._headerCode);
    }

    protected StringBuffer generateFooterCode() {
        StringBuffer footer = new StringBuffer();
        this.generateCloseBlock(footer);
        return footer;
    }

    protected void initializeCode(String className, ClassInfo classInfo) {
        this._className = className;
        this._headerCode = this.beginHeaderCode(this._className);
        this._bodyCode = this.beginBodyCode();
        this._importSet = new HashSet();
    }

    protected StringBuffer beginBodyCode() {
        StringBuffer code = new StringBuffer();
        return code;
    }

    protected void generateOperations(ClassInfo classInfo, StringBuffer code) {
        Capability capability = classInfo.getCapability();
        Iterator i = capability.getOperations().iterator();
        while (i.hasNext()) {
            JavaMethod method = (JavaMethod)i.next();
            this.indent(code);
            code.append("public " + this.convertType(method.getReturnType(), classInfo) + " " + this.getMethodName(method));
            Class[] params = method.getParameterTypes();
            QName[] paramNames = method.getParameterTypeNames();
            code.append("(");
            if (params.length > 0) {
                int j;
                for (j = 0; j < params.length - 1; ++j) {
                    code.append(this.convertType(params[j], classInfo) + " " + this.getParamName(paramNames[j], j) + ", ");
                }
                code.append(this.convertType(params[j], classInfo) + " " + this.getParamName(paramNames[j], j));
            }
            code.append(") throws Exception");
            this.generateOperationBody(method, code);
            this.newLine(2, code);
        }
    }

    protected void generateOperationBody(JavaMethod method, StringBuffer code) {
        code.append(";");
    }

    protected void generatePropertyOperations(ClassInfo classInfo, StringBuffer code) {
        Capability capability = classInfo.getCapability();
        if (capability.getProperties().size() == 0) {
            return;
        }
        Iterator i = capability.getProperties().iterator();
        while (i.hasNext()) {
            JavaProperty property = (JavaProperty)i.next();
            this.generateGetOperation(property, classInfo, code);
            this.genereateSetOperation(property, classInfo, code);
        }
    }

    protected void genereateSetOperation(JavaProperty property, ClassInfo classInfo, StringBuffer code) {
        this.indent(code);
        code.append("public void");
        code.append(" set" + this.getPropertyName(property, true) + "(" + this.convertType(property.getJavaType(), classInfo) + " param0)");
        this.generateSetOperationBody(property, code);
        this.newLine(2, code);
    }

    protected void generateSetOperationBody(JavaProperty property, StringBuffer code) {
        code.append(";");
    }

    protected void generateGetOperation(JavaProperty property, ClassInfo classInfo, StringBuffer code) {
        this.indent(code);
        code.append("public " + this.convertType(property.getJavaType(), classInfo) + " get" + this.getPropertyName(property, true) + "()");
        this.generateGetOperationBody(property, code);
        this.newLine(2, code);
    }

    protected void generateGetOperationBody(JavaProperty property, StringBuffer code) {
        code.append(";");
    }

    protected void generateNSDeclarations(ClassInfo classInfo, StringBuffer code) {
        Capability capability = classInfo.getCapability();
        this.indent(code);
        this.statement("String PREFIX = \"tns\";", code);
        this.newLine(2, code);
        this.indent(code);
        this.statement("String NAMESPACE_URI = \"" + capability.getURI() + "\";", code);
        this.newLine(2, code);
    }

    protected Class getBaseClass(Capability capability) {
        if (capability.getProperties().size() > 0) {
            return class$org$apache$muse$ws$resource$impl$AbstractWsResourceCapability == null ? (class$org$apache$muse$ws$resource$impl$AbstractWsResourceCapability = ServerInterfaceSynthesizer.class$("org.apache.muse.ws.resource.impl.AbstractWsResourceCapability")) : class$org$apache$muse$ws$resource$impl$AbstractWsResourceCapability;
        }
        return class$org$apache$muse$core$AbstractCapability == null ? (class$org$apache$muse$core$AbstractCapability = ServerInterfaceSynthesizer.class$("org.apache.muse.core.AbstractCapability")) : class$org$apache$muse$core$AbstractCapability;
    }

    protected void addImports(Class[] classes) {
        for (int i = 0; i < classes.length; ++i) {
            this.addImport(classes[i]);
        }
    }

    protected void addImport(Class className) {
        this._importSet.add(className);
    }

    public ConfigurationDataDescriptor[] getConfigurationDataDescriptions() {
        return REQUIRED_PARAMETERS;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

