/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.tools.generator.synthesizer;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.muse.tools.generator.synthesizer.ClassInfo;
import org.apache.muse.tools.generator.synthesizer.ServerInterfaceSynthesizer;
import org.apache.muse.tools.generator.util.Capability;
import org.apache.muse.tools.inspector.JavaMethod;
import org.apache.muse.tools.inspector.JavaProperty;
import org.apache.muse.util.ReflectUtils;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;

public class ServerClassSynthesizer
extends ServerInterfaceSynthesizer {
    private static Messages _MESSAGES = MessagesFactory.get((Object)(class$org$apache$muse$tools$generator$synthesizer$ServerClassSynthesizer == null ? (class$org$apache$muse$tools$generator$synthesizer$ServerClassSynthesizer = ServerClassSynthesizer.class$("org.apache.muse.tools.generator.synthesizer.ServerClassSynthesizer")) : class$org$apache$muse$tools$generator$synthesizer$ServerClassSynthesizer));
    static /* synthetic */ Class class$org$apache$muse$tools$generator$synthesizer$ServerClassSynthesizer;
    static /* synthetic */ Class class$javax$xml$namespace$QName;
    static /* synthetic */ Class class$org$apache$muse$ws$addressing$soap$SoapFault;

    protected void generateCapability(Capability capability, Map files, Set ignoreSet) {
        ClassInfo classInfo = new ClassInfo(capability);
        String className = this.generateClassName(capability);
        this.initializeCode(className, classInfo);
        this.addImport(this.getBaseClass(capability));
        if (classInfo.needsInitializer()) {
            this.generateInitialize(classInfo, this._bodyCode);
        }
        if (!capability.isEmpty()) {
            this.generatePropertiesDeclarations(classInfo, this._bodyCode);
            this.generatePropertyOperations(classInfo, this._bodyCode);
            this.generateOperations(classInfo, this._bodyCode);
        }
        classInfo.addImports(this._importSet);
        capability.setImplementingClass(className);
        String classFileName = this.createFileName(className);
        files.put(classFileName, this.generateCombinedCode(classInfo));
        ignoreSet.add(new File(classFileName));
    }

    protected void endHeaderCode(ClassInfo classInfo) {
        this.generateImports(classInfo, this._headerCode);
        Capability capability = classInfo.getCapability();
        String[] interfaces = null;
        if (!capability.isEmpty()) {
            interfaces = new String[]{ReflectUtils.getShortName((String)this.generateClassName("I", capability))};
        }
        String parentClass = this.convertType(this.getBaseClass(capability), classInfo);
        this.generateClassDef(this._className, parentClass, interfaces, false, this._headerCode);
    }

    protected void generatePropertiesDeclarations(ClassInfo classInfo, StringBuffer code) {
        JavaProperty property;
        Capability capability = classInfo.getCapability();
        if (capability.getProperties().size() == 0) {
            return;
        }
        this.indent(code);
        code.append("private static final " + this.convertType(class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = ServerClassSynthesizer.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName, classInfo) + "[] _PROPERTIES = new " + this.convertType(class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = ServerClassSynthesizer.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName, classInfo) + "[]");
        this.newLine(code);
        this.addImport(class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = ServerClassSynthesizer.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
        this.indent(code);
        this.generateOpenBlock(code);
        this.newLine(code);
        Iterator i = capability.getProperties().iterator();
        while (i.hasNext()) {
            property = (JavaProperty)i.next();
            this.indent(2, code);
            code.append("new " + this.convertType(class$javax$xml$namespace$QName == null ? ServerClassSynthesizer.class$("javax.xml.namespace.QName") : class$javax$xml$namespace$QName, classInfo) + "(NAMESPACE_URI, \"" + this.getPropertyName(property, false) + "\", PREFIX)");
            if (i.hasNext()) {
                code.append(",");
            }
            this.newLine(code);
        }
        this.indent(code);
        this.generateCloseBlock(code);
        this.statement(";", code);
        this.newLine(2, code);
        this.indent(code);
        code.append("public " + this.convertType(class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = ServerClassSynthesizer.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName, classInfo) + "[] getPropertyNames()");
        this.newLine(code);
        this.indent(code);
        this.generateOpenBlock(code);
        this.newLine(code);
        this.indent(2, code);
        code.append("return _PROPERTIES;");
        this.newLine(code);
        this.indent(code);
        this.generateCloseBlock(code);
        this.newLine(2, code);
        i = capability.getProperties().iterator();
        while (i.hasNext()) {
            property = (JavaProperty)i.next();
            this.indent(code);
            code.append("private " + this.convertType(property.getJavaType(), classInfo) + " _" + this.getPropertyName(property, false) + ";");
            this.newLine(2, code);
        }
    }

    protected void generateInitialize(ClassInfo classInfo, StringBuffer code) {
        this.indent(code);
        code.append("public void initialize() throws SoapFault ");
        this.newLine(code);
        this.indent(code);
        this.generateOpenBlock(code);
        this.addImport(class$org$apache$muse$ws$addressing$soap$SoapFault == null ? (class$org$apache$muse$ws$addressing$soap$SoapFault = ServerClassSynthesizer.class$("org.apache.muse.ws.addressing.soap.SoapFault")) : class$org$apache$muse$ws$addressing$soap$SoapFault);
        this.generateSuperInitialize(code);
        this.newLine(code);
        if (classInfo.getCapability().isEmpty()) {
            this.generateEmptyInitTodo(code);
        } else {
            this.generatePropertyInitTodo(classInfo, code);
        }
        this.indent(code);
        this.generateCloseBlock(code);
        this.newLine(2, code);
    }

    private void generateSuperInitialize(StringBuffer code) {
        this.newLine(code);
        this.indent(2, code);
        code.append("//");
        this.newLine(code);
        this.indent(2, code);
        code.append("//" + _MESSAGES.get("InitializeComment", false));
        this.newLine(code);
        this.indent(2, code);
        code.append("//");
        this.newLine(code);
        this.indent(2, code);
        code.append("super.initialize();");
        this.newLine(code);
    }

    protected void generateEmptyInitTodo(StringBuffer code) {
        this.indent(2, code);
        code.append("//");
        this.newLine(code);
        this.indent(2, code);
        code.append("//" + _MESSAGES.get("InitEmptyTODO", false));
        this.newLine(code);
        this.indent(2, code);
        code.append("//");
        this.newLine(code);
    }

    protected void generatePropertyInitTodo(ClassInfo classInfo, StringBuffer code) {
        this.indent(2, code);
        code.append("//");
        this.newLine(code);
        this.indent(2, code);
        code.append("//" + _MESSAGES.get("InitTODO", false));
        this.newLine(code);
        this.indent(2, code);
        code.append("//");
        this.newLine(code);
        Iterator i = classInfo.getCapability().getProperties().iterator();
        while (i.hasNext()) {
            JavaProperty property = (JavaProperty)i.next();
            if (property.getJavaType().isPrimitive()) continue;
            this.indent(2, code);
            code.append("// " + property.getName().getLocalPart());
            this.newLine(code);
        }
        this.indent(2, code);
        code.append("//");
        this.newLine(2, code);
        this.indent(2, code);
        code.append("throw new RuntimeException(\"" + _MESSAGES.get("InitThrow", false) + "\");");
        this.newLine(code);
    }

    protected void generateGetOperationBody(JavaProperty property, StringBuffer code) {
        this.newLine(code);
        this.indent(code);
        this.generateOpenBlock(code);
        this.newLine(code);
        this.indent(2, code);
        this.statement("return _" + this.getPropertyName(property, false) + ";", code);
        this.newLine(code);
        this.indent(code);
        this.generateCloseBlock(code);
    }

    protected void generateOperationBody(JavaMethod method, StringBuffer code) {
        this.indent(code);
        this.generateOpenBlock(code);
        this.newLine(code);
        this.indent(2, code);
        code.append("//TODO implement " + this.getMethodName(method));
        this.newLine(code);
        this.indent(2, code);
        code.append("throw new RuntimeException(\"Unimplemented Method: " + this.getMethodName(method) + "\");");
        this.newLine(code);
        this.indent(code);
        this.generateCloseBlock(code);
    }

    protected void generateSetOperationBody(JavaProperty property, StringBuffer code) {
        this.newLine(code);
        this.indent(code);
        this.generateOpenBlock(code);
        this.newLine(code);
        this.indent(2, code);
        this.statement("_" + this.getPropertyName(property, false) + " = param0;", code);
        this.newLine(code);
        this.indent(code);
        this.generateCloseBlock(code);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

