/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.tools.generator.synthesizer;

import java.lang.reflect.Constructor;
import java.util.HashSet;
import javax.xml.namespace.QName;
import org.apache.muse.tools.generator.synthesizer.ClassInfo;
import org.apache.muse.tools.generator.synthesizer.ProxyInterfaceSynthesizer;
import org.apache.muse.tools.generator.util.ConfigurationData;
import org.apache.muse.tools.generator.util.ConfigurationDataDescriptor;
import org.apache.muse.tools.inspector.JavaMethod;
import org.apache.muse.tools.inspector.JavaProperty;
import org.apache.muse.tools.inspector.ResourceInspector;
import org.apache.muse.util.ReflectUtils;
import org.apache.muse.util.xml.XsdUtils;
import org.w3c.dom.Document;

public class ProxyClassSynthesizer
extends ProxyInterfaceSynthesizer {
    static ConfigurationDataDescriptor[] REQUIRED_PARAMETERS = new ConfigurationDataDescriptor[]{ConfigurationData.CAPABILITIES_MAP_LIST_CONFIGURATION, ConfigurationData.GENERATE_CUSTOM_HEADERS_CONFIGURATION, ConfigurationData.WSDL_DOCUMENT_LIST_CONFIGURATION};
    StringBuffer _operationNamesCode;
    StringBuffer _returnTypesCode;
    StringBuffer _actionsCode;
    StringBuffer _requestNamesCode;
    StringBuffer _responseNamesCode;
    StringBuffer _requestParamNamesCode;
    StringBuffer _propertiesOperationsCode;
    private String _interfaceName;
    private boolean _hasMethods = false;
    private boolean _hasProperties = false;
    static /* synthetic */ Class class$javax$xml$namespace$QName;
    static /* synthetic */ Class class$org$apache$muse$core$proxy$ProxyHandler;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$HashMap;
    static /* synthetic */ Class class$org$apache$muse$core$proxy$ReflectionProxyHandler;

    protected String generateClassName(Document wsdlDocument) {
        this._interfaceName = super.generateClassName(wsdlDocument);
        return this._interfaceName + "Proxy";
    }

    protected void initializeCode(String className) {
        this._importSet = new HashSet();
        this.addImport(this._baseClientClass);
        this._className = className;
        this._headerCode = this.beginHeaderCode(this._className);
        this._operationsCode = this.beginOperationsCode();
        this._operationNamesCode = this.beginOperationNamesCode();
        this._returnTypesCode = this.beginReturnTypesCode();
        this._actionsCode = this.beginActionsCode();
        this._requestNamesCode = this.beginRequestNamesCode();
        this._responseNamesCode = this.beginResponseNamesCode();
        this._requestParamNamesCode = this.beginRequestParamNamesCode();
        this.resetIndex();
    }

    private StringBuffer beginRequestParamNamesCode() {
        StringBuffer code = new StringBuffer();
        this.indent(code);
        code.append("private static final QName[][] _REQUEST_PARAM_NAMES = {");
        this.newLine(code);
        this._importSet.add(class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = ProxyClassSynthesizer.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
        return code;
    }

    private StringBuffer beginResponseNamesCode() {
        StringBuffer code = new StringBuffer();
        this.indent(code);
        code.append("private static final QName[] _RESPONSE_NAMES = {");
        this.newLine(code);
        this.indent(2, code);
        this._importSet.add(class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = ProxyClassSynthesizer.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
        return code;
    }

    private StringBuffer beginRequestNamesCode() {
        StringBuffer code = new StringBuffer();
        this.indent(code);
        code.append("private static final QName[] _REQUEST_NAMES = {");
        this.newLine(code);
        this.indent(2, code);
        this._importSet.add(class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = ProxyClassSynthesizer.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
        return code;
    }

    private StringBuffer beginActionsCode() {
        StringBuffer code = new StringBuffer();
        this.indent(code);
        code.append("private static final String[] _ACTIONS = {");
        this.newLine(code);
        this.indent(2, code);
        return code;
    }

    private StringBuffer beginReturnTypesCode() {
        StringBuffer code = new StringBuffer();
        this.indent(code);
        code.append("private static final Class[] _RETURN_TYPES = {");
        this.newLine(code);
        this.indent(2, code);
        return code;
    }

    private StringBuffer beginOperationsCode() {
        return new StringBuffer();
    }

    private StringBuffer beginOperationNamesCode() {
        StringBuffer code = new StringBuffer();
        this.indent(code);
        code.append("private static final String[] _METHOD_NAMES = {");
        this.newLine(code);
        this.indent(2, code);
        return code;
    }

    protected void updateCode(ClassInfo classInfo) {
        this.updateMethods(classInfo, this._operationsCode);
        classInfo.addImports(this._importSet);
    }

    protected void generateMethodQualifier(StringBuffer code) {
        code.append("public ");
    }

    protected void generateMethodBody(JavaMethod method, ClassInfo classInfo, StringBuffer code) {
        this._hasMethods = true;
        this.newLine(code);
        this.indent(code);
        this.generateOpenBlock(code);
        this.newLine(code);
        this.generateParamConversion(method, code);
        this.generateHandler(method, classInfo, code);
        this.generateInvoke(method, code);
        this.indent(code);
        this.generateCloseBlock(code);
        this.updateMethodNames(method);
        this.updateReturnTypes(method);
        this.updateActions(method);
        this.updateRequestNames(method);
        this.updateResponseNames(method);
        this.updateRequestParamNamesCode(method);
    }

    private void generateParamConversion(JavaMethod operation, StringBuffer code) {
        QName[] paramNames = operation.getParameterTypeNames();
        Class[] paramTypes = operation.getParameterTypes();
        this.indent(2, code);
        code.append("Object[] params = new Object[");
        code.append(paramTypes.length);
        code.append("];");
        this.newLine(code);
        if (paramTypes.length > 0) {
            this.newLine(code);
        }
        for (int n = 0; n < paramTypes.length; ++n) {
            this.indent(2, code);
            code.append("params[");
            code.append(n);
            code.append("] = ");
            String name = ResourceInspector.getLowerCamelName(paramNames[n].getLocalPart());
            code.append(this.getObjectName(name, paramTypes[n]));
            code.append(";");
            this.newLine(code);
        }
        this.newLine(code);
    }

    private void generateHandler(JavaMethod method, ClassInfo classInfo, StringBuffer code) {
        this.indent(2, code);
        code.append("ProxyHandler handler = getHandler(\"");
        code.append(method.getJavaName());
        code.append("\");");
        this.newLine(code);
        classInfo.addImport(class$org$apache$muse$core$proxy$ProxyHandler == null ? (class$org$apache$muse$core$proxy$ProxyHandler = ProxyClassSynthesizer.class$("org.apache.muse.core.proxy.ProxyHandler")) : class$org$apache$muse$core$proxy$ProxyHandler);
    }

    private void generateInvoke(JavaMethod method, StringBuffer code) {
        this.indent(2, code);
        Class returnType = method.getReturnType();
        if (returnType == Void.TYPE) {
            code.append(this.getInvokeString() + ";");
        } else if (!returnType.isPrimitive()) {
            code.append("return (");
            code.append(ReflectUtils.getShortName((Class)returnType));
            code.append(")" + this.getInvokeString() + ";");
        } else {
            String className = this.getPrimitiveClassName(returnType);
            String convertMethodName = this.getPrimitiveConvertMethodName(className);
            code.append(className);
            code.append(" result = (");
            code.append(className);
            code.append(")" + this.getInvokeString() + ";");
            this.newLine(code);
            this.indent(2, code);
            code.append("return result.");
            code.append(convertMethodName);
            code.append("();");
        }
        this.newLine(code);
    }

    private String getInvokeString() {
        if (this._generateCustomHeaders) {
            return "invoke(handler, params, customHeaders)";
        }
        return "invoke(handler, params)";
    }

    private void updateRequestParamNamesCode(JavaMethod method) {
        QName[] names = method.getParameterTypeNames();
        this.indent(2, this._requestParamNamesCode);
        this.generateOpenBlock(this._requestParamNamesCode);
        this.newLine(this._requestParamNamesCode);
        for (int i = 0; i < names.length; ++i) {
            this.indent(3, this._requestParamNamesCode);
            this.generateQName(names[i], this._requestParamNamesCode);
            this._requestParamNamesCode.append(",");
            this.newLine(this._requestParamNamesCode);
        }
        if (names.length > 0) {
            int length = this._requestParamNamesCode.length();
            this._requestParamNamesCode.delete(length - 2, length);
        }
        this.newLine(this._requestParamNamesCode);
        this.indent(2, this._requestParamNamesCode);
        this.generateCloseBlock(this._requestParamNamesCode);
        this._requestParamNamesCode.append(",");
        this.newLine(this._requestParamNamesCode);
    }

    private void updateResponseNames(JavaMethod method) {
        QName returnName = method.getReturnName();
        if (returnName != null && !returnName.equals(XsdUtils.ANY_TYPE_QNAME)) {
            this.generateQName(returnName, this._responseNamesCode);
        } else {
            this._responseNamesCode.append("null");
        }
        this._responseNamesCode.append(", ");
    }

    private void updateRequestNames(JavaMethod method) {
        QName returnName = method.getName();
        if (returnName != null && !returnName.equals(XsdUtils.ANY_TYPE_QNAME)) {
            this.generateQName(returnName, this._requestNamesCode);
        } else {
            this._requestNamesCode.append("null");
        }
        this._requestNamesCode.append(", ");
    }

    private void updateMethodNames(JavaMethod method) {
        this._operationNamesCode.append('\"');
        this._operationNamesCode.append(method.getJavaName());
        this._operationNamesCode.append('\"');
        this._operationNamesCode.append(", ");
    }

    private void updateReturnTypes(JavaMethod method) {
        Class type = method.getReturnType();
        if (type.isArray()) {
            type = ReflectUtils.getClassFromArrayClass((Class)type);
        }
        this._returnTypesCode.append(ReflectUtils.getShortName((Class)type));
        this._returnTypesCode.append(".class");
        this._returnTypesCode.append(", ");
    }

    private void updateActions(JavaMethod method) {
        this._actionsCode.append('\"');
        this._actionsCode.append(method.getActionURI());
        this._actionsCode.append('\"');
        this._actionsCode.append(", ");
    }

    protected void generatePropertyDeleteBody(JavaProperty property, ClassInfo classInfo, int propertyIndex, StringBuffer code) {
        this._hasProperties = true;
        this.newLine(code);
        this.indent(code);
        this.generateOpenBlock(code);
        this.newLine(code);
        this.indent(2, code);
        code.append("deleteResourceProperty(PROPERTIES[");
        code.append(propertyIndex);
        code.append("]);\n");
        this.indent(code);
        this.generateCloseBlock(code);
    }

    protected void generatePropertyGetBody(JavaProperty property, ClassInfo classInfo, int propertyIndex, StringBuffer code) {
        this._hasProperties = true;
        Class type = property.getJavaType();
        this.newLine(code);
        this.indent(code);
        this.generateOpenBlock(code);
        this.newLine(code);
        if (type.isArray()) {
            this.indent(2, code);
            code.append("return (");
            code.append(ReflectUtils.getShortName((Class)type));
            code.append(")getPropertyAsObject(");
            code.append("PROPERTIES[");
            code.append(propertyIndex);
            code.append("], ");
            type = ReflectUtils.getClassFromArrayClass((Class)type);
            code.append(ReflectUtils.getShortName((Class)type));
            code.append(".class);");
            this.newLine(code);
        } else {
            this.indent(2, code);
            Class array = ReflectUtils.getArrayClassFromClass((Class)type);
            code.append(ReflectUtils.getShortName((Class)array));
            code.append(" results = (");
            code.append(ReflectUtils.getShortName((Class)array));
            code.append(")getPropertyAsObject(");
            code.append("PROPERTIES[");
            code.append(propertyIndex);
            code.append("], ");
            code.append(ReflectUtils.getShortName((Class)type));
            code.append(".class);");
            this.newLine(code);
            this.indent(2, code);
            code.append("return results.length == 0 ? ");
            code.append(this.getNullValue(type));
            code.append(" : results[0];");
            this.newLine(code);
        }
        this.indent(code);
        this.generateCloseBlock(code);
    }

    protected void generatePropertySetBody(JavaProperty property, ClassInfo classInfo, int propertyIndex, String setType, StringBuffer code) {
        this._hasProperties = true;
        Class type = property.getJavaType();
        if (type.isArray()) {
            type = ReflectUtils.getClassFromArrayClass((Class)type);
        }
        this.newLine(code);
        this.indent(code);
        this.generateOpenBlock(code);
        this.newLine(code);
        this.indent(2, code);
        code.append(setType);
        code.append("ResourceProperty(PROPERTIES[");
        code.append(propertyIndex);
        code.append("], ");
        if (type.isArray()) {
            code.append("value");
        } else {
            code.append("new Object[]{ ");
            code.append(this.getArrayValue(type));
            code.append(" }");
        }
        code.append(");");
        this.newLine(code);
        this.indent(code);
        this.generateCloseBlock(code);
    }

    public String generateCombinedCode(ClassInfo classInfo) {
        this.endDeclarationCode(this._operationNamesCode);
        this.endDeclarationCode(this._returnTypesCode);
        this.endDeclarationCode(this._actionsCode);
        this.endDeclarationCode(this._requestNamesCode);
        this.endDeclarationCode(this._responseNamesCode);
        this.endDeclarationCode(this._requestParamNamesCode);
        StringBuffer footerCode = this.generateFooterCode();
        classInfo.addImports(this._importSet);
        this.endHeaderCode(classInfo);
        StringBuffer code = new StringBuffer();
        code.append(this._headerCode);
        if (this._hasProperties || this._hasMethods) {
            code.append(this._operationsCode);
            this.newLine(code);
        }
        if (this._hasMethods) {
            code.append(this._operationNamesCode);
            this.newLine(code);
            code.append(this._returnTypesCode);
            this.newLine(code);
            code.append(this._actionsCode);
            this.newLine(code);
            code.append(this._requestNamesCode);
            this.newLine(code);
            code.append(this._responseNamesCode);
            this.newLine(code);
            code.append(this._requestParamNamesCode);
        }
        code.append(footerCode);
        return code.toString();
    }

    protected void endHeaderCode(ClassInfo classInfo) {
        this.generateImports(classInfo, this._headerCode);
        String[] interfaces = new String[]{ReflectUtils.getShortName((String)this._interfaceName)};
        String parentClass = ReflectUtils.getShortName((Class)this._baseClientClass);
        this.generateClassDef(this._className, parentClass, interfaces, false, this._headerCode);
    }

    private StringBuffer generateFooterCode() {
        StringBuffer code = new StringBuffer();
        this.generateProxyConstructors(code);
        if (this._hasMethods) {
            this.generateGetHandler(code);
            this.newLine(code);
            this.generateStatic(code);
        }
        this.generateCloseBlock(code);
        this.newLine(code);
        return code;
    }

    private void generateProxyConstructors(StringBuffer code) {
        String className = ReflectUtils.getShortName((String)this._className);
        Constructor<?>[] ctors = this._baseClientClass.getConstructors();
        for (int n = 0; n < ctors.length; ++n) {
            this.indent(code);
            code.append("public ");
            code.append(className);
            Class<?>[] params = ctors[n].getParameterTypes();
            this.generateParamList(null, ctors[n].getParameterTypes(), code);
            this.addImports(ctors[n].getParameterTypes());
            this.indent(code);
            this.generateOpenBlock(code);
            this.newLine(code);
            this.indent(2, code);
            code.append("super(");
            for (int i = 0; i < params.length; ++i) {
                code.append("param" + i);
                if (i == params.length - 1) continue;
                code.append(", ");
            }
            code.append(");");
            this.newLine(code);
            this.indent(code);
            this.generateCloseBlock(code);
            this.newLine(2, code);
        }
    }

    private void generateGetHandler(StringBuffer code) {
        this.indent(code);
        code.append("protected ProxyHandler getHandler(String methodName)");
        this.addImport(class$org$apache$muse$core$proxy$ProxyHandler == null ? (class$org$apache$muse$core$proxy$ProxyHandler = ProxyClassSynthesizer.class$("org.apache.muse.core.proxy.ProxyHandler")) : class$org$apache$muse$core$proxy$ProxyHandler);
        this.newLine(code);
        this.indent(code);
        this.generateOpenBlock(code);
        this.newLine(code);
        this.indent(2, code);
        this.statement("return (ProxyHandler)_HANDLERS_BY_NAME.get(methodName);", code);
        this.newLine(code);
        this.indent(code);
        this.generateCloseBlock(code);
    }

    private void generateStatic(StringBuffer code) {
        this.newLine(code);
        this.indent(code);
        this.statement("private static final Map _HANDLERS_BY_NAME = new HashMap();", code);
        this.addImport(class$java$util$Map == null ? (class$java$util$Map = ProxyClassSynthesizer.class$("java.util.Map")) : class$java$util$Map);
        this.addImport(class$java$util$HashMap == null ? (class$java$util$HashMap = ProxyClassSynthesizer.class$("java.util.HashMap")) : class$java$util$HashMap);
        this.newLine(2, code);
        this.indent(code);
        code.append("static");
        this.newLine(code);
        this.indent(code);
        this.generateOpenBlock(code);
        this.newLine(code);
        this.indent(2, code);
        code.append("for (int n = 0; n < _METHOD_NAMES.length; ++n)");
        this.newLine(code);
        this.indent(2, code);
        this.generateOpenBlock(code);
        this.newLine(code);
        this.indent(3, code);
        code.append("ProxyHandler handler = new ReflectionProxyHandler();");
        this.addImport(class$org$apache$muse$core$proxy$ReflectionProxyHandler == null ? (class$org$apache$muse$core$proxy$ReflectionProxyHandler = ProxyClassSynthesizer.class$("org.apache.muse.core.proxy.ReflectionProxyHandler")) : class$org$apache$muse$core$proxy$ReflectionProxyHandler);
        this.newLine(code);
        this.indent(3, code);
        code.append("handler.setAction(_ACTIONS[n]);");
        this.newLine(code);
        this.indent(3, code);
        code.append("handler.setRequestName(_REQUEST_NAMES[n]);");
        this.newLine(code);
        this.indent(3, code);
        code.append("handler.setRequestParameterNames(_REQUEST_PARAM_NAMES[n]);");
        this.newLine(code);
        this.indent(3, code);
        code.append("handler.setResponseName(_RESPONSE_NAMES[n]);");
        this.newLine(code);
        this.indent(3, code);
        code.append("handler.setReturnType(_RETURN_TYPES[n]);");
        this.newLine(2, code);
        this.indent(3, code);
        code.append("_HANDLERS_BY_NAME.put(_METHOD_NAMES[n], handler);");
        this.newLine(code);
        this.indent(2, code);
        this.generateCloseBlock(code);
        this.newLine(code);
        this.indent(code);
        this.generateCloseBlock(code);
    }

    private void endDeclarationCode(StringBuffer code) {
        int length = code.length();
        code.delete(length - 2, length);
        this.newLine(code);
        this.indent(code);
        this.generateCloseBlock(code);
        code.append(";");
        this.newLine(code);
    }

    public ConfigurationDataDescriptor[] getConfigurationDataDescriptions() {
        return REQUIRED_PARAMETERS;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

