/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.tools.generator.synthesizer;

import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.muse.tools.generator.synthesizer.ClassInfo;
import org.apache.muse.tools.generator.synthesizer.Synthesizer;
import org.apache.muse.tools.generator.util.Capability;
import org.apache.muse.tools.generator.util.ConfigurationData;
import org.apache.muse.tools.generator.util.ConfigurationDataDescriptor;
import org.apache.muse.tools.inspector.JavaMethod;
import org.apache.muse.tools.inspector.JavaProperty;
import org.apache.muse.util.ReflectUtils;

public abstract class AbstractSynthesizer
implements Synthesizer {
    static final String INDENT = "    ";
    static final String REQUEST_SUFFIX = "Request";
    private static final String JAVA_CLASS_NAME = "MyCapability";
    static final String INTERFACE_PREFIX = "I";
    private int _prefixCounter = 0;
    private HashMap _prefixes = new HashMap();

    protected String createFileName(String interfaceName) {
        return interfaceName.replaceAll("\\.", "\\" + File.separator) + ".java";
    }

    protected String generateClassName(Capability capability) {
        return this.generateClassName(null, capability);
    }

    protected String generateClassName(String prefix, Capability capability) {
        String implementingClass = capability.getImplementingClass();
        String packageName = null;
        String shortClassName = null;
        if (implementingClass == null) {
            packageName = ClassInfo.getPackageName(capability.getURI());
            shortClassName = JAVA_CLASS_NAME;
        } else {
            packageName = ReflectUtils.getPackageName((String)implementingClass);
            shortClassName = ReflectUtils.getShortName((String)implementingClass);
        }
        if (prefix != null) {
            shortClassName = prefix + shortClassName;
        }
        return packageName + "." + shortClassName;
    }

    protected String getMethodName(JavaMethod method) {
        String name = method.getJavaName();
        if (name.endsWith(REQUEST_SUFFIX)) {
            name = name.substring(0, name.indexOf(REQUEST_SUFFIX));
        }
        return name;
    }

    protected void generateClassDef(String remoteClassName, boolean isInterface, StringBuffer code) {
        this.generateClassDef(remoteClassName, null, null, isInterface, code);
    }

    protected void generateClassDef(String remoteClassName, String extendsClass, String[] implementsClasses, boolean isInterface, StringBuffer code) {
        code.append("public ");
        code.append(isInterface ? "interface" : "class");
        code.append(" ");
        code.append(ReflectUtils.getShortName((String)remoteClassName));
        if (extendsClass != null) {
            code.append(" extends " + extendsClass);
        }
        if (implementsClasses != null && implementsClasses.length > 0) {
            code.append(" implements ");
            code.append(implementsClasses[0]);
            for (int i = 1; i < implementsClasses.length; ++i) {
                code.append(", " + implementsClasses[i]);
            }
        }
        this.newLine(code);
        this.generateOpenBlock(code);
        this.newLine(code);
    }

    protected void generateImports(ClassInfo classInfo, StringBuffer code) {
        Iterator i = classInfo.getImports().iterator();
        while (i.hasNext()) {
            String className = this.needsImport((Class)i.next());
            if (className == null) continue;
            this.statement("import " + className + ";", code);
            this.newLine(code);
        }
        this.newLine(code);
    }

    protected String needsImport(Class className) {
        if (className.isPrimitive()) {
            return null;
        }
        if (className.isArray()) {
            className = ReflectUtils.getClassFromArrayClass((Class)className);
        }
        if (className.getName().startsWith("java.lang.")) {
            return null;
        }
        return className.getName();
    }

    protected String convertType(Class returnType, ClassInfo classInfo) {
        boolean isArray = returnType.isArray();
        Class clazz = returnType = isArray ? ReflectUtils.getClassFromArrayClass((Class)returnType) : returnType;
        if (classInfo.hasConflict(returnType)) {
            return returnType.getName();
        }
        return ReflectUtils.getShortName((Class)returnType) + (isArray ? "[]" : "");
    }

    protected String getPropertyName(JavaProperty property, boolean forSetter) {
        String name = property.getName().getLocalPart();
        if (!forSetter) {
            return name;
        }
        name = name.substring(0, 1).toUpperCase() + name.substring(1);
        return name;
    }

    protected String getParamName(QName paramName, int position) {
        String name = paramName == null ? "param" + position : paramName.getLocalPart();
        return name;
    }

    protected void statement(String statement, StringBuffer code) {
        code.append(statement);
    }

    protected void generateHeaderComment(String className, StringBuffer code) {
        String shortName = ReflectUtils.getShortName((String)className);
        String fileName = shortName + ".java";
        this.comment(code);
        this.newLine(code);
        this.comment(fileName, code);
        this.newLine(code);
        this.comment(new Date().toString(), code);
        this.newLine(code);
        this.comment("Generated by the Apache Muse Code Generation Tool", code);
        this.newLine(code);
        this.comment(code);
        this.newLine(code);
    }

    protected void generatePackage(String className, StringBuffer code) {
        String packageName = ReflectUtils.getPackageName((String)className);
        if (packageName != null) {
            this.statement("package " + packageName + ";", code);
            this.newLine(2, code);
        }
    }

    protected void comment(StringBuffer code) {
        this.comment("", code);
    }

    protected void comment(String comment, StringBuffer code) {
        code.append("// " + comment);
    }

    protected void newLine(StringBuffer code) {
        this.newLine(1, code);
    }

    protected void newLine(int n, StringBuffer code) {
        for (int i = 0; i < n; ++i) {
            code.append("\n");
        }
    }

    protected void generateCloseBlock(StringBuffer code) {
        code.append("}");
    }

    protected void generateOpenBlock(StringBuffer code) {
        code.append("{");
    }

    protected void indent(StringBuffer code) {
        this.indent(1, code);
    }

    protected void indent(int indent, StringBuffer code) {
        for (int i = 0; i < indent; ++i) {
            code.append(INDENT);
        }
    }

    protected String getObjectName(String name, Class type) {
        if (!type.isPrimitive()) {
            return name;
        }
        if (type == Boolean.TYPE) {
            return "new Boolean(" + name + ')';
        }
        if (type == Double.TYPE) {
            return "new Double(" + name + ')';
        }
        if (type == Float.TYPE) {
            return "new Float(" + name + ')';
        }
        if (type == Integer.TYPE) {
            return "new Integer(" + name + ')';
        }
        if (type == Long.TYPE) {
            return "new Long(" + name + ')';
        }
        return "new Short(" + name + ')';
    }

    protected String getPrimitiveClassName(Class type) {
        if (type == Boolean.TYPE) {
            return "Boolean";
        }
        if (type == Float.TYPE || type == Double.TYPE) {
            return "Float";
        }
        return "Integer";
    }

    protected String getPrimitiveConvertMethodName(String type) {
        if (type.endsWith("Boolean")) {
            return "booleanValue";
        }
        if (type.endsWith("Float") || type.endsWith("Double")) {
            return "floatValue";
        }
        return "intValue";
    }

    protected String getArrayValue(Class type) {
        if (!type.isPrimitive()) {
            return "value";
        }
        if (type == Boolean.TYPE) {
            return "Boolean.toString(value)";
        }
        if (type == Float.TYPE || type == Double.TYPE) {
            return "Double.toString(value)";
        }
        return "Long.toString(value)";
    }

    protected String getNullValue(Class type) {
        if (!type.isPrimitive()) {
            return "null";
        }
        if (type == Boolean.TYPE) {
            return "false";
        }
        return "0";
    }

    protected void generateQName(QName qname, StringBuffer code) {
        this.generateQName(qname.getNamespaceURI(), qname.getLocalPart(), code);
    }

    protected void generateQName(String uri, String name, StringBuffer code) {
        code.append("new QName(\"");
        if (uri != null && uri.length() > 0) {
            code.append(uri);
            code.append("\", \"");
        }
        code.append(name);
        code.append("\", \"");
        code.append(this.getPrefix(uri));
        code.append("\")");
    }

    protected String getPrefix(String uri) {
        String prefix = (String)this._prefixes.get(uri);
        if (prefix == null) {
            prefix = "pfx" + this._prefixCounter++;
            this._prefixes.put(uri, prefix);
        }
        return prefix;
    }

    protected StringBuffer beginHeaderCode(String className) {
        StringBuffer code = new StringBuffer();
        this.generateHeaderComment(className, code);
        this.generatePackage(className, code);
        return code;
    }

    public abstract /* synthetic */ ConfigurationData synthesize(ConfigurationData var1) throws Exception;

    public abstract /* synthetic */ ConfigurationDataDescriptor[] getConfigurationDataDescriptions();
}

