/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.tools.generator.projectizer;

import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.muse.tools.generator.projectizer.AbstractProjectizer;
import org.apache.muse.tools.generator.projectizer.MiniProjectizerConstants;
import org.apache.muse.tools.generator.util.Capability;
import org.apache.muse.tools.generator.util.ConfigurationData;
import org.apache.muse.tools.generator.util.ConfigurationDataDescriptor;
import org.apache.muse.tools.generator.util.DeploymentDescriptorHelper;
import org.apache.muse.tools.generator.util.ServicesDescriptorHelper;
import org.apache.muse.util.FileUtils;
import org.apache.muse.ws.resource.metadata.MetadataDescriptor;
import org.apache.muse.ws.resource.metadata.impl.WsrmdUtils;
import org.apache.muse.ws.wsdl.WsdlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class J2EEMiniProjectizer
extends AbstractProjectizer {
    static ConfigurationDataDescriptor[] REQUIRED_PARAMETERS = new ConfigurationDataDescriptor[]{ConfigurationData.FILES_MAP_LIST_CONFIGURATION, ConfigurationData.DESCRIPTOR_DOCUMENT_CONFIGURATION, ConfigurationData.WSDL_DOCUMENT_LIST_CONFIGURATION, ConfigurationData.OVERWRITE_CONFIGURATION, ConfigurationData.CAPABILITIES_MAP_LIST_CONFIGURATION};
    protected Map[] _capabilitiesList = null;
    protected Map[] _filesMaps = null;
    protected Document _descriptor = null;
    protected Document[] _wsdls = null;
    protected Set[] _ignoreSets = null;
    protected MetadataDescriptor[] _metadatas = null;
    static /* synthetic */ Class class$org$apache$muse$ws$resource$impl$SimpleWsResource;
    static /* synthetic */ Class class$org$apache$muse$core$SimpleResource;

    public void projectize(ConfigurationData configuration) throws Exception {
        ConfigurationData.checkConfiguration(this, configuration);
        this.loadParameters(configuration);
        File webContentDir = new File(this._targetDirectory, "WebContent");
        File javaSourceDir = new File(this._targetDirectory, "JavaSource");
        this.createDirectoryStructure(webContentDir);
        this.createJavaSources(javaSourceDir, this._filesMaps, this._ignoreSets);
        this.createArtifacts(webContentDir);
        this.createOverwriteManifest();
    }

    protected void createArtifacts(File webContentDir) throws Exception {
        File webInfDir = new File(webContentDir, "WEB-INF");
        File descriptorFile = new File(webContentDir, "WEB-INF/classes/muse.xml");
        this.createFileFromResource(this._targetDirectory, "/resources/mini/build.xml", "build.xml");
        this.createFileFromResource(webInfDir, "/resources/mini/web.xml", "web.xml");
        File wsdldir = new File(webContentDir, "WEB-INF/classes/wsdl");
        File routerEntriesDir = new File(webContentDir, "WEB-INF/classes/router-entries");
        for (int i = 0; i < this._capabilitiesList.length; ++i) {
            Map capabilities = this._capabilitiesList[i];
            Document wsdl = this._wsdls[i];
            MetadataDescriptor rmd = this._metadatas[i];
            this.createDescriptor(this._descriptor, wsdl, descriptorFile, capabilities, "/wsdl/", i);
            this.createWSDLFile(wsdl, wsdldir);
            this.createRMDFile(rmd, wsdl, wsdldir);
            this.createRouterEntries(routerEntriesDir, WsdlUtils.getServiceName((Element)wsdl.getDocumentElement()), capabilities);
        }
    }

    protected void createRMDFile(MetadataDescriptor rmd, Document wsdl, File wsdldir) throws Exception {
        if (rmd == null) {
            return;
        }
        File rmdFile = new File(this.getMetadataFileName(wsdldir.getPath(), wsdl));
        this.updatePortType(wsdl, rmd, rmdFile);
        this.writeToFileCheck(WsrmdUtils.createMetadataDocument((MetadataDescriptor)rmd), rmdFile);
    }

    protected void createDirectoryStructure(File webContentDir) throws Exception {
        File webInfLibDir = new File(webContentDir, "WEB-INF/lib");
        File museModulesDir = new File(System.getProperty("MUSE_HOME"), "modules");
        File museLibDir = new File(System.getProperty("MUSE_HOME"), "lib");
        this.copyJars(MiniProjectizerConstants.REQUIRED_MODULES, museModulesDir, webInfLibDir);
        this.copyJars(MiniProjectizerConstants.REQUIRED_LIBRARIES, museLibDir, webInfLibDir);
    }

    protected void loadParameters(ConfigurationData configuration) {
        this._capabilitiesList = (Map[])configuration.getParameter("capabilities_map_list");
        this._filesMaps = (Map[])configuration.getParameter("files_map_list");
        this._descriptor = (Document)configuration.getParameter("descriptor_document");
        this._wsdls = (Document[])configuration.getParameter("wsdl_documents");
        this._targetDirectory = (File)configuration.getParameter("target_dir");
        this._ignoreSets = (Set[])configuration.getParameter("ignore_sets");
        this._metadatas = (MetadataDescriptor[])configuration.getParameter("metadata_list");
        boolean overwrite = (Boolean)configuration.getParameter("overwrite");
        this.setTargetDirectory((File)configuration.getParameter("target_dir"), overwrite);
    }

    protected void createWSDLFile(Document wsdl, File wsdldir) throws Exception {
        File wsdlFile = new File(this.getWsdlFileName(wsdldir.getPath(), wsdl));
        this.writeToFileCheck(wsdl, wsdlFile);
    }

    protected void createFileFromResource(File baseTargetDir, String fileResource, String fileName) throws Exception {
        InputStream template = FileUtils.loadFromContext(this.getClass(), (String)fileResource);
        File file = new File(baseTargetDir, fileName);
        this.copyStreamCheck(template, file);
    }

    protected void updateServicesDescriptor(ServicesDescriptorHelper servicesHelper, Document wsdl, Map capabilities) {
        String serviceName = WsdlUtils.getServiceName((Element)wsdl.getDocumentElement());
        servicesHelper.createService(serviceName);
        Iterator i = capabilities.values().iterator();
        while (i.hasNext()) {
            servicesHelper.addActionMappings((Capability)i.next(), serviceName);
        }
    }

    protected void createDescriptor(Document descriptorDocument, Document wsdl, File descriptorFile, Map capabilities, String wsdlRelativePath, int resourceIndex) throws Exception {
        if (capabilities.keySet().contains("http://docs.oasis-open.org/wsn/bw-2/SubscriptionManager")) {
            return;
        }
        DeploymentDescriptorHelper helper = new DeploymentDescriptorHelper(descriptorDocument, wsdl, resourceIndex);
        helper.setWsdlFile(this.getWsdlFileName(wsdlRelativePath, wsdl));
        helper.setContextPath(WsdlUtils.getServiceName((Element)wsdl.getDocumentElement()));
        helper.setJavaResourceClass(this.getResourceClass(capabilities).getName());
        Iterator i = capabilities.values().iterator();
        while (i.hasNext()) {
            helper.addCapability((Capability)i.next());
        }
        this.writeToFileCheck(descriptorDocument, descriptorFile);
    }

    protected Class getResourceClass(Map capabilities) {
        Iterator i = capabilities.values().iterator();
        while (i.hasNext()) {
            Capability capability = (Capability)i.next();
            if (capability.getProperties().size() <= 0) continue;
            return class$org$apache$muse$ws$resource$impl$SimpleWsResource == null ? (class$org$apache$muse$ws$resource$impl$SimpleWsResource = J2EEMiniProjectizer.class$("org.apache.muse.ws.resource.impl.SimpleWsResource")) : class$org$apache$muse$ws$resource$impl$SimpleWsResource;
        }
        return class$org$apache$muse$core$SimpleResource == null ? (class$org$apache$muse$core$SimpleResource = J2EEMiniProjectizer.class$("org.apache.muse.core.SimpleResource")) : class$org$apache$muse$core$SimpleResource;
    }

    public ConfigurationDataDescriptor[] getConfigurationDataDescriptions() {
        return REQUIRED_PARAMETERS;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

