/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.tools.generator;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.apache.muse.core.Environment;
import org.apache.muse.tools.generator.WsdlMergeConstants;
import org.apache.muse.tools.generator.util.AbstractCommandLineApp;
import org.apache.muse.tools.generator.util.DefinitionInfo;
import org.apache.muse.tools.generator.util.MuseRuntimeException;
import org.apache.muse.tools.generator.util.WsdlEnvironment;
import org.apache.muse.util.CommandLine;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.resource.metadata.MetadataDescriptor;
import org.apache.muse.ws.resource.metadata.WsrmdConstants;
import org.apache.muse.ws.resource.metadata.impl.SimpleMetadataDescriptor;
import org.apache.muse.ws.resource.metadata.impl.WsrmdUtils;
import org.apache.muse.ws.wsdl.WsdlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WsdlMerge
extends AbstractCommandLineApp
implements WsdlMergeConstants {
    private static Messages _MESSAGES = MessagesFactory.get((Object)(class$org$apache$muse$tools$generator$WsdlMerge == null ? (class$org$apache$muse$tools$generator$WsdlMerge = WsdlMerge.class$("org.apache.muse.tools.generator.WsdlMerge")) : class$org$apache$muse$tools$generator$WsdlMerge));
    private static WSDLFactory _factory;
    private static WSDLReader _reader;
    private static WSDLWriter _writer;
    static /* synthetic */ Class class$org$apache$muse$tools$generator$WsdlMerge;

    public static void main(String[] args) {
        try {
            CommandLine arguments = WsdlMerge.parseParameters(args);
            AbstractCommandLineApp.createLogger(arguments);
            WsdlMerge.checkHelpArg(arguments);
            WsdlMerge.checkVersionArg(arguments);
            File[] files = WsdlMerge.checkFileArgs(arguments);
            String outputFileName = WsdlMerge.checkOutputArg(arguments);
            String outputRMDFileName = WsdlMerge.checkOutputRMDArg(arguments);
            boolean overwrite = AbstractCommandLineApp.checkOverwriteArg(arguments);
            String uri = WsdlMerge.checkUriArg(arguments);
            String address = WsdlMerge.checkAddressArg(arguments);
            WsdlMerge.run(files, outputFileName, outputRMDFileName, overwrite, uri, address);
        }
        catch (Exception e) {
            Object[] filler = new Object[]{"-verbose"};
            AbstractCommandLineApp.handleErrorAndExit(_MESSAGES.get("WsdlMergeFailed", filler), e);
        }
    }

    public static void run(File[] files, String outputFileName, String outputRMDFileName, boolean overwrite, String uri, String address) throws FileNotFoundException {
        Document[] wsdls = new Document[files.length];
        MetadataDescriptor[] metadatas = new MetadataDescriptor[files.length];
        for (int i = 0; i < files.length; ++i) {
            WsdlEnvironment env = new WsdlEnvironment(files[i].getAbsoluteFile().getParentFile());
            wsdls[i] = WsdlUtils.createWSDL((Environment)env, (String)files[i].getName(), (boolean)true);
            WsdlUtils.removeSchemaReferences((Element)wsdls[i].getDocumentElement());
            WsdlUtils.removeWsdlReferences((Element)wsdls[i].getDocumentElement());
            if (outputRMDFileName == null) continue;
            metadatas[i] = AbstractCommandLineApp.getMetadataDescriptor(files[i].getName(), (Environment)env, wsdls[i]);
        }
        Definition mergedWsdl = WsdlMerge.merge(uri, wsdls, address);
        if (outputRMDFileName != null) {
            MetadataDescriptor mergedMetadata = WsdlMerge.merge(outputFileName, WsdlMerge.getFirstPortType(mergedWsdl).getQName(), metadatas);
            WsdlMerge.setMetadata(mergedMetadata.getName(), outputRMDFileName, mergedWsdl);
            WsdlMerge.writeRmd(outputRMDFileName, mergedMetadata, overwrite);
        }
        WsdlMerge.writeWsdl(outputFileName, mergedWsdl, overwrite);
    }

    private static void setMetadata(String metadataName, String metadataLocation, Definition mergedWsdl) {
        mergedWsdl.addNamespace("wsrmd", "http://docs.oasis-open.org/wsrf/rmd-1");
        PortType portType = WsdlMerge.getFirstPortType(mergedWsdl);
        portType.setExtensionAttribute(WsrmdConstants.DESCRIPTOR_ATTR_QNAME, (Object)metadataName);
        portType.setExtensionAttribute(WsrmdConstants.DESCRIPTOR_LOCATION_ATTR_QNAME, (Object)metadataLocation);
    }

    private static PortType getFirstPortType(Definition wsdl) {
        return (PortType)wsdl.getPortTypes().values().iterator().next();
    }

    public static MetadataDescriptor merge(String wsdlLocation, QName interfaceName, MetadataDescriptor[] metadatas) {
        SimpleMetadataDescriptor mergedMetadata = new SimpleMetadataDescriptor("Metadata", wsdlLocation, interfaceName);
        for (int i = 0; i < metadatas.length; ++i) {
            WsdlMerge.copyMetadata(metadatas[i], (MetadataDescriptor)mergedMetadata);
        }
        return mergedMetadata;
    }

    private static String checkOutputRMDArg(CommandLine arguments) {
        return arguments.getFlagValue("-rmdoutput");
    }

    private static void checkVersionArg(CommandLine arguments) {
        if (arguments.hasFlag("-version")) {
            AbstractCommandLineApp.handleMessage(AbstractCommandLineApp.getVersion());
            AbstractCommandLineApp.handleExit();
        }
    }

    public static Definition merge(String namespaceURI, Document[] wsdlFragments, String address) {
        DefinitionInfo targetDefinition = new DefinitionInfo(namespaceURI);
        DefinitionInfo definition = null;
        for (int i = 0; i < wsdlFragments.length; ++i) {
            try {
                definition = new DefinitionInfo(WsdlMerge.load(wsdlFragments[i]));
            }
            catch (WSDLException e) {
                Object[] filler = new Object[]{new Integer(i)};
                throw new MuseRuntimeException("WsdlFragmentParseFailed", _MESSAGES.get("WsdlFragmentParseFailed", filler), (Exception)((Object)e));
            }
            WsdlMerge.copyOperations(definition, targetDefinition);
            WsdlMerge.copyProperties(definition, targetDefinition);
        }
        targetDefinition.createBinding();
        targetDefinition.createService(address);
        return targetDefinition.getDefinition();
    }

    private static void copyMetadata(MetadataDescriptor sourceMetadata, MetadataDescriptor targetMetadata) {
        if (sourceMetadata == null) {
            return;
        }
        Iterator i = sourceMetadata.getPropertyNames().iterator();
        while (i.hasNext()) {
            QName nextProperty = (QName)i.next();
            if (targetMetadata.hasProperty(nextProperty)) {
                Object[] filler = new Object[]{nextProperty};
                throw new MuseRuntimeException("DuplicateProperty", _MESSAGES.get("DuplicateProperty", filler));
            }
            try {
                WsdlMerge.addProperty(nextProperty, sourceMetadata, targetMetadata);
            }
            catch (Exception e) {
                Object[] filler = new Object[]{nextProperty};
                throw new MuseRuntimeException("FailedCopyingProperty", _MESSAGES.get("FailedCopyingProperty", filler), e);
            }
        }
    }

    public static void addProperty(QName name, MetadataDescriptor source, MetadataDescriptor target) throws Exception {
        if (name == null) {
            throw new NullPointerException();
        }
        if (source == null) {
            throw new NullPointerException();
        }
        if (target == null) {
            throw new NullPointerException();
        }
        String mutability = source.getMutability(name);
        String modifiability = source.getModifiability(name);
        ArrayList initialValues = new ArrayList(source.getInitialValues(name));
        ArrayList staticValues = new ArrayList(source.getStaticValues(name));
        ArrayList validValues = new ArrayList(source.getValidValues(name));
        target.addProperty(name, modifiability, mutability);
        target.setInitialValues(name, initialValues);
        target.setStaticValues(name, staticValues);
        target.setValidValues(name, validValues);
        if (validValues.isEmpty()) {
            target.setLowerBound(name, source.getLowerBound(name));
            target.setUpperBound(name, source.getUpperBound(name));
        }
        Iterator j = source.getExtendedMetadataNames(name).iterator();
        while (j.hasNext()) {
            QName metadataName = (QName)j.next();
            String metadataValue = source.getExtendedMetadata(name, metadataName);
            target.setExtendedMetadata(name, metadataName, metadataValue);
        }
    }

    private static void copyProperties(DefinitionInfo sourceDefinition, DefinitionInfo targetDefinition) {
        Types types = sourceDefinition.getTypes();
        Iterator i = types.getExtensibilityElements().iterator();
        while (i.hasNext()) {
            targetDefinition.addSchema((Schema)i.next());
        }
        targetDefinition.mergeProperties(sourceDefinition);
    }

    private static void copyOperations(DefinitionInfo sourceDefinition, DefinitionInfo targetDefinition) {
        HashMap localMessageMap = new HashMap();
        Iterator i = sourceDefinition.getOperations().iterator();
        while (i.hasNext()) {
            Operation nextOperation = (Operation)i.next();
            targetDefinition.addOperation(nextOperation, localMessageMap);
        }
    }

    private static void checkHelpArg(CommandLine arguments) {
        if (arguments.hasFlag("-help") || AbstractCommandLineApp.hasNoArguments(arguments)) {
            Object[] filler = new Object[]{"-uri", "-address", "-output", "-uri", "-address", "-output", "-rmdoutput", "-overwrite", "-version", "-help"};
            AbstractCommandLineApp.handleMessage(_MESSAGES.get("WsdlMergeHelp", filler, false));
            AbstractCommandLineApp.handleExit();
        }
    }

    private static String checkAddressArg(CommandLine arguments) {
        String addressArg = arguments.getFlagValue("-address");
        if (addressArg == null) {
            Object[] filler = new Object[]{"-address", "-help"};
            throw new MuseRuntimeException("NoAddressFlag", _MESSAGES.get("NoAddressFlag", filler));
        }
        return addressArg;
    }

    private static String checkUriArg(CommandLine arguments) {
        String uriArg = arguments.getFlagValue("-uri");
        if (uriArg == null) {
            Object[] filler = new Object[]{"-uri", "-help"};
            throw new MuseRuntimeException("NoURIFlag", _MESSAGES.get("NoURIFlag", filler));
        }
        return uriArg;
    }

    private static String checkOutputArg(CommandLine arguments) {
        String outputArg = arguments.getFlagValue("-output");
        if (outputArg == null) {
            Object[] filler = new Object[]{"-output", "-help"};
            throw new MuseRuntimeException("NoOutputFlag", _MESSAGES.get("NoOutputFlag", filler));
        }
        return outputArg;
    }

    private static File[] checkFileArgs(CommandLine arguments) {
        String[] argFiles = arguments.getArguments();
        File[] files = new File[argFiles.length];
        for (int i = 0; i < argFiles.length; ++i) {
            files[i] = new File(argFiles[i]);
            if (files[i].exists()) continue;
            Object[] filler = new Object[]{files[i]};
            throw new MuseRuntimeException("NonExistant", _MESSAGES.get("NonExistant", filler));
        }
        if (files.length == 0) {
            Object[] filler = new Object[]{"-help"};
            throw new MuseRuntimeException("NoWSDLs", _MESSAGES.get("NoWSDLs", filler));
        }
        return files;
    }

    private static Definition load(Document document) throws WSDLException {
        String parent = null;
        return _reader.readWSDL(parent, document);
    }

    private static void writeRmd(String fileName, MetadataDescriptor metadata, boolean overwrite) {
        File metadataDestination = new File(fileName);
        if (!metadataDestination.exists() || overwrite) {
            try {
                AbstractCommandLineApp.checkParentDirectory(metadataDestination.getAbsoluteFile().getParentFile());
                Element rmdDoc = WsrmdUtils.createMetadataDocument((MetadataDescriptor)metadata);
                FileWriter fileWriter = new FileWriter(metadataDestination);
                fileWriter.write(XmlUtils.toString((Node)rmdDoc));
                fileWriter.close();
            }
            catch (Exception e) {
                Object[] filler = new Object[]{metadataDestination.getAbsolutePath()};
                throw new MuseRuntimeException("FailedWritingRmd", _MESSAGES.get("FailedWritingRmd", filler), e);
            }
        } else {
            AbstractCommandLineApp.handleMessage(_MESSAGES.get("NotOverwriting", (Object[])new String[]{metadataDestination.getPath()}));
        }
    }

    private static void writeWsdl(String fileName, Definition mergedDefinition, boolean overwrite) {
        File wsdlDestination = new File(fileName);
        if (!wsdlDestination.exists() || overwrite) {
            try {
                AbstractCommandLineApp.checkParentDirectory(wsdlDestination.getAbsoluteFile().getParentFile());
                Document wsdlDoc = _writer.getDocument(mergedDefinition);
                FileWriter fileWriter = new FileWriter(wsdlDestination);
                fileWriter.write(XmlUtils.toString((Node)wsdlDoc));
                fileWriter.close();
            }
            catch (Exception e) {
                Object[] filler = new Object[]{wsdlDestination.getAbsolutePath()};
                throw new MuseRuntimeException("FailedWritingWsdl", _MESSAGES.get("FailedWritingWsdl", filler), e);
            }
        } else {
            AbstractCommandLineApp.handleMessage(_MESSAGES.get("NotOverwriting", (Object[])new String[]{wsdlDestination.getPath()}));
        }
    }

    private static CommandLine parseParameters(String[] args) {
        CommandLine arguments = new CommandLine();
        arguments.saveFlagValue("-uri");
        arguments.saveFlagValue("-address");
        arguments.saveFlagValue("-output");
        arguments.saveFlagValue("-rmdoutput");
        arguments.parse(args);
        return arguments;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            _factory = WSDLFactory.newInstance();
            _reader = _factory.newWSDLReader();
            _writer = _factory.newWSDLWriter();
            _reader.setFeature("javax.wsdl.verbose", false);
        }
        catch (Exception e) {
            throw new MuseRuntimeException("NoFactory", _MESSAGES.get("NoFactory"), e);
        }
    }
}

