/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.tools.generator;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.muse.core.Environment;
import org.apache.muse.tools.generator.Wsdl2JavaConstants;
import org.apache.muse.tools.generator.analyzer.Analyzer;
import org.apache.muse.tools.generator.analyzer.SimpleAnalyzer;
import org.apache.muse.tools.generator.projectizer.J2EEAxis2Projectizer;
import org.apache.muse.tools.generator.projectizer.J2EEMiniProjectizer;
import org.apache.muse.tools.generator.projectizer.OsgiAxis2Projectizer;
import org.apache.muse.tools.generator.projectizer.OsgiMiniProjectizer;
import org.apache.muse.tools.generator.projectizer.Projectizer;
import org.apache.muse.tools.generator.projectizer.ProxyProjectizer;
import org.apache.muse.tools.generator.synthesizer.ProxySynthesizer;
import org.apache.muse.tools.generator.synthesizer.ServerSynthesizer;
import org.apache.muse.tools.generator.synthesizer.Synthesizer;
import org.apache.muse.tools.generator.util.AbstractCommandLineApp;
import org.apache.muse.tools.generator.util.ConfigurationData;
import org.apache.muse.tools.generator.util.MuseRuntimeException;
import org.apache.muse.tools.generator.util.WsdlEnvironment;
import org.apache.muse.util.CommandLine;
import org.apache.muse.util.FileUtils;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.resource.metadata.MetadataDescriptor;
import org.w3c.dom.Document;

public class Wsdl2Java
extends AbstractCommandLineApp
implements Wsdl2JavaConstants {
    private static Messages _MESSAGES = MessagesFactory.get((Object)(class$org$apache$muse$tools$generator$Wsdl2Java == null ? (class$org$apache$muse$tools$generator$Wsdl2Java = Wsdl2Java.class$("org.apache.muse.tools.generator.Wsdl2Java")) : class$org$apache$muse$tools$generator$Wsdl2Java));
    private Synthesizer _synthesizer;
    private Projectizer _projectizer;
    private Analyzer _analyzer;
    private ConfigurationData _configuration;
    static /* synthetic */ Class class$org$apache$muse$tools$generator$Wsdl2Java;
    static /* synthetic */ Class class$org$apache$muse$tools$generator$analyzer$Analyzer;
    static /* synthetic */ Class class$org$apache$muse$tools$generator$synthesizer$Synthesizer;
    static /* synthetic */ Class class$org$apache$muse$tools$generator$projectizer$Projectizer;

    public Wsdl2Java(File wsdlFile) throws Exception {
        this(wsdlFile, null, false, false, null);
    }

    public Wsdl2Java(File wsdlFile, boolean overwrite) throws Exception {
        this(wsdlFile, null, overwrite, false, null);
    }

    public Wsdl2Java(File wsdlFile, File descriptorFile, boolean overwrite, boolean generateCustomHeaders, File targetDirectory) throws Exception {
        Document descriptorDocument = this.getDescriptorDocument(descriptorFile);
        Document[] wsdlDocuments = null;
        MetadataDescriptor[] metadataDescriptors = null;
        WsdlEnvironment env = null;
        if (wsdlFile == null && descriptorFile == null) {
            AbstractCommandLineApp.handleErrorAndExit(_MESSAGES.get("NullWSDLBuiltinDescriptor"));
        }
        if (wsdlFile != null) {
            env = new WsdlEnvironment(wsdlFile.getAbsoluteFile().getParentFile());
            wsdlDocuments = new Document[]{AbstractCommandLineApp.getWSDLDocument(wsdlFile.getName(), (Environment)env)};
            metadataDescriptors = new MetadataDescriptor[]{AbstractCommandLineApp.getMetadataDescriptor(wsdlFile.getName(), (Environment)env, wsdlDocuments[0])};
        } else {
            env = new WsdlEnvironment(descriptorFile.getAbsoluteFile().getParentFile());
            wsdlDocuments = AbstractCommandLineApp.getWSDLDocuments(descriptorFile, descriptorDocument);
            metadataDescriptors = AbstractCommandLineApp.getMetadataDescriptors(descriptorFile, descriptorDocument);
        }
        this._configuration = new ConfigurationData();
        this._configuration.addParameter("wsdl_documents", wsdlDocuments);
        this._configuration.addParameter("descriptor_document", descriptorDocument);
        this._configuration.addParameter("overwrite", overwrite);
        this._configuration.addParameter("generate_custom_headers", generateCustomHeaders);
        this._configuration.addParameter("target_dir", targetDirectory);
        this._configuration.addParameter("metadata_list", metadataDescriptors);
    }

    private Document getDescriptorDocument(File file) {
        Document result = null;
        if (file == null) {
            InputStream inputStream = FileUtils.loadFromContext((Class)(class$org$apache$muse$tools$generator$Wsdl2Java == null ? (class$org$apache$muse$tools$generator$Wsdl2Java = Wsdl2Java.class$("org.apache.muse.tools.generator.Wsdl2Java")) : class$org$apache$muse$tools$generator$Wsdl2Java), (String)"/resources/common/muse.xml");
            if (inputStream == null) {
                throw new RuntimeException(_MESSAGES.get("FailedLoadingBuiltinDescriptor"));
            }
            try {
                result = XmlUtils.createDocument((InputStream)inputStream);
            }
            catch (Exception e) {
                Object[] filler = AbstractCommandLineApp.getFiller(e);
                throw new RuntimeException(_MESSAGES.get("FailedLoadingDescriptor", filler));
            }
        }
        try {
            result = XmlUtils.createDocument((File)file);
        }
        catch (Exception e) {
            Object[] filler = AbstractCommandLineApp.getFiller(e);
            throw new RuntimeException(_MESSAGES.get("FailedLoadingDescriptor", filler));
        }
        return result;
    }

    public void run() throws Exception {
        this._projectizer.projectize(this._synthesizer.synthesize(this._analyzer.analyze(this._configuration)));
    }

    public void setAnalyzer(Analyzer analyzer) {
        this._analyzer = analyzer;
    }

    public void setProjectizer(Projectizer projectizer) {
        this._projectizer = projectizer;
    }

    public void setSynthesizer(Synthesizer synthesizer) {
        this._synthesizer = synthesizer;
    }

    public ConfigurationData getConfigurationData() {
        return this._configuration;
    }

    public static void main(String[] args) {
        CommandLine arguments = Wsdl2Java.parseParameters(args);
        AbstractCommandLineApp.createLogger(arguments);
        Wsdl2Java.checkHelpArg(arguments);
        Wsdl2Java.checkVersionArg(arguments);
        Wsdl2Java.checkBaseDescriptorArg(arguments);
        boolean overwrite = AbstractCommandLineApp.checkOverwriteArg(arguments);
        boolean generateCustomHeaders = Wsdl2Java.checkHeadersFlag(arguments);
        File outputDirectory = Wsdl2Java.checkOutputArg(arguments);
        File wsdl = Wsdl2Java.checkWsdlArg(arguments);
        File descriptorFile = Wsdl2Java.checkDescriptorArg(arguments);
        Analyzer analyzer = Wsdl2Java.checkAnalyzerArg(arguments);
        Synthesizer synthesizer = Wsdl2Java.checkSynthesizerArg(arguments);
        Projectizer projectizer = Wsdl2Java.checkProjectizerArg(arguments);
        Wsdl2Java app = null;
        try {
            app = new Wsdl2Java(wsdl, descriptorFile, overwrite, generateCustomHeaders, outputDirectory);
            app.setAnalyzer(analyzer);
            app.setSynthesizer(synthesizer);
            app.setProjectizer(projectizer);
        }
        catch (Exception e) {
            AbstractCommandLineApp.handleErrorAndExit(e.getMessage(), e);
            return;
        }
        try {
            app.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractCommandLineApp.handleErrorAndExit(_MESSAGES.get("CodeGenFailed"), e);
        }
    }

    private static File checkOutputArg(CommandLine arguments) {
        String outputArg = arguments.getFlagValue("-output");
        if (outputArg == null) {
            return null;
        }
        File outputDirectory = new File(outputArg);
        if (outputDirectory.exists() && !outputDirectory.isDirectory()) {
            Object[] filler = new Object[]{outputDirectory.getAbsoluteFile()};
            AbstractCommandLineApp.handleErrorAndExit(_MESSAGES.get("NotDirectory", filler));
        }
        return outputDirectory;
    }

    private static void checkVersionArg(CommandLine arguments) {
        if (arguments.hasFlag("-version")) {
            AbstractCommandLineApp.handleMessage(AbstractCommandLineApp.getVersion());
            AbstractCommandLineApp.handleExit();
        }
    }

    private static boolean checkHeadersFlag(CommandLine arguments) {
        return arguments.hasFlag("-headers");
    }

    private static CommandLine parseParameters(String[] args) {
        CommandLine arguments = new CommandLine();
        arguments.saveFlagValue("-analyzer");
        arguments.saveFlagValue("-synthesizer");
        arguments.saveFlagValue("-projectizer");
        arguments.saveFlagValue("-wsdl");
        arguments.saveFlagValue("-descriptor");
        arguments.saveFlagValue("-dump");
        arguments.saveFlagValue("-output");
        arguments.saveFlagValue("-j2ee");
        arguments.saveFlagValue("-osgi");
        arguments.parse(args);
        return arguments;
    }

    private static void checkHelpArg(CommandLine arguments) {
        Object[] filler;
        if (arguments.hasFlag("-helpmore")) {
            filler = new Object[]{"-wsdl", "-descriptor", "-wsdl", "-descriptor", "-j2ee", "-osgi", "-proxy", "axis2", "mini", "-output", "-overwrite", "-analyzer", "-synthesizer", "-projectizer", "-dump", "-headers", "-quiet", "-verbose", "-version", "-help", "-helpmore"};
            AbstractCommandLineApp.handleMessage(_MESSAGES.get("Wsdl2JavaHelpAdvanced", filler, false));
            AbstractCommandLineApp.handleExit();
        }
        if (arguments.hasFlag("-help") || AbstractCommandLineApp.hasNoArguments(arguments)) {
            filler = new Object[]{"-wsdl", "-wsdl", "-j2ee", "-osgi", "-proxy", "axis2", "mini", "-output", "-overwrite", "-help", "-helpmore"};
            AbstractCommandLineApp.handleMessage(_MESSAGES.get("Wsdl2JavaHelp", filler, false));
            AbstractCommandLineApp.handleExit();
        }
    }

    private static void checkBaseDescriptorArg(CommandLine arguments) {
        boolean overwrite = AbstractCommandLineApp.checkOverwriteArg(arguments);
        String baseDescriptorArg = arguments.getFlagValue("-dump");
        if (arguments.hasFlag("-dump")) {
            if (baseDescriptorArg == null) {
                Object[] filler = new Object[]{"-dump"};
                AbstractCommandLineApp.handleErrorAndExit(_MESSAGES.get("NoBaseDescriptorOutput", filler, false));
            } else {
                File target = new File(baseDescriptorArg);
                if (!target.exists() || overwrite) {
                    Object[] filler = new Object[]{target.getAbsolutePath()};
                    AbstractCommandLineApp.handleMessage(_MESSAGES.get("WritingTo", filler, false));
                    try {
                        InputStream baseDescriptor = FileUtils.loadFromContext((Class)(class$org$apache$muse$tools$generator$Wsdl2Java == null ? (class$org$apache$muse$tools$generator$Wsdl2Java = Wsdl2Java.class$("org.apache.muse.tools.generator.Wsdl2Java")) : class$org$apache$muse$tools$generator$Wsdl2Java), (String)"/resources/common/muse.xml");
                        FileUtils.copyFile((InputStream)baseDescriptor, (File)target);
                    }
                    catch (IOException e) {
                        AbstractCommandLineApp.handleErrorAndExit(_MESSAGES.get("CopyingBaseDescriptorFailed"), e);
                    }
                    AbstractCommandLineApp.handleMessage(_MESSAGES.get("WritingComplete", false));
                } else {
                    Object[] filler = new Object[]{target.getAbsolutePath(), "-overwrite"};
                    AbstractCommandLineApp.handleMessage(_MESSAGES.get("ExistingFound", filler, false));
                }
            }
            AbstractCommandLineApp.handleExit();
        }
    }

    private static File checkWsdlArg(CommandLine arguments) {
        String wsdlArg = arguments.getFlagValue("-wsdl");
        if (wsdlArg == null) {
            return null;
        }
        File wsdlFile = new File(wsdlArg);
        if (!wsdlFile.exists()) {
            Object[] filler = new Object[]{wsdlFile.getAbsolutePath()};
            AbstractCommandLineApp.handleErrorAndExit(_MESSAGES.get("WsdlNotFound", filler));
        }
        return wsdlFile;
    }

    private static File checkDescriptorArg(CommandLine arguments) {
        File descriptorFile = null;
        String descriptorArg = arguments.getFlagValue("-descriptor");
        if (arguments.hasFlag("-descriptor")) {
            Object[] filler;
            if (descriptorArg == null) {
                filler = new Object[]{"-descriptor"};
                AbstractCommandLineApp.handleErrorAndExit(_MESSAGES.get("NullDescriptor", filler));
            }
            if (!(descriptorFile = new File(descriptorArg)).exists()) {
                filler = new Object[]{descriptorFile.getAbsolutePath()};
                AbstractCommandLineApp.handleErrorAndExit(_MESSAGES.get("DescriptorNotFound", filler));
            }
        }
        return descriptorFile;
    }

    private static Analyzer checkAnalyzerArg(CommandLine arguments) {
        Analyzer analyzer = null;
        String analyzerArg = arguments.getFlagValue("-analyzer");
        if (arguments.hasFlag("-analyzer")) {
            if (analyzerArg == null) {
                Object[] filler = new Object[]{"-analyzer"};
                AbstractCommandLineApp.handleErrorAndExit(_MESSAGES.get("NullAnalyzer", filler));
            }
        } else {
            return new SimpleAnalyzer();
        }
        analyzer = (Analyzer)Wsdl2Java.loadClass(arguments.getFlagValue("-analyzer"), class$org$apache$muse$tools$generator$analyzer$Analyzer == null ? (class$org$apache$muse$tools$generator$analyzer$Analyzer = Wsdl2Java.class$("org.apache.muse.tools.generator.analyzer.Analyzer")) : class$org$apache$muse$tools$generator$analyzer$Analyzer);
        return analyzer;
    }

    private static Synthesizer checkSynthesizerArg(CommandLine arguments) {
        if (arguments.hasFlag("-proxy")) {
            return new ProxySynthesizer();
        }
        String generatorArg = arguments.getFlagValue("-synthesizer");
        if (arguments.hasFlag("-synthesizer")) {
            if (generatorArg == null) {
                Object[] filler = new Object[]{"-synthesizer"};
                AbstractCommandLineApp.handleErrorAndExit(_MESSAGES.get("NullSynthesizer", filler));
            }
            return (Synthesizer)Wsdl2Java.loadClass(arguments.getFlagValue("-synthesizer"), class$org$apache$muse$tools$generator$synthesizer$Synthesizer == null ? (class$org$apache$muse$tools$generator$synthesizer$Synthesizer = Wsdl2Java.class$("org.apache.muse.tools.generator.synthesizer.Synthesizer")) : class$org$apache$muse$tools$generator$synthesizer$Synthesizer);
        }
        return new ServerSynthesizer();
    }

    private static Projectizer checkProjectizerArg(CommandLine arguments) {
        if (arguments.hasFlag("-proxy")) {
            return new ProxyProjectizer();
        }
        if (arguments.hasFlag("-j2ee")) {
            String type = arguments.getFlagValue("-j2ee");
            if (type == null) {
                Object[] filler = new Object[]{"-help"};
                throw new MuseRuntimeException("InvalidArgs", _MESSAGES.get("InvalidArgs", filler));
            }
            if (type.equals("mini")) {
                return new J2EEMiniProjectizer();
            }
            if (type.equals("axis2")) {
                return new J2EEAxis2Projectizer();
            }
            Object[] filler = new Object[]{"-help"};
            throw new MuseRuntimeException("InvalidArgs", _MESSAGES.get("InvalidArgs", filler));
        }
        if (arguments.hasFlag("-osgi")) {
            String type = arguments.getFlagValue("-osgi");
            if (type == null) {
                Object[] filler = new Object[]{"-help"};
                throw new MuseRuntimeException("InvalidArgs", _MESSAGES.get("InvalidArgs", filler));
            }
            if (type.equals("mini")) {
                return new OsgiMiniProjectizer();
            }
            if (type.equals("axis2")) {
                return new OsgiAxis2Projectizer();
            }
            Object[] filler = new Object[]{"-help"};
            throw new MuseRuntimeException("InvalidArgs", _MESSAGES.get("InvalidArgs", filler));
        }
        String projectizerArg = arguments.getFlagValue("-projectizer");
        if (arguments.hasFlag("-projectizer")) {
            if (projectizerArg == null) {
                Object[] filler = new Object[]{"-projectizer"};
                AbstractCommandLineApp.handleErrorAndExit(_MESSAGES.get("NullProjectizer", filler));
            }
            return (Projectizer)Wsdl2Java.loadClass(arguments.getFlagValue("-projectizer"), class$org$apache$muse$tools$generator$projectizer$Projectizer == null ? (class$org$apache$muse$tools$generator$projectizer$Projectizer = Wsdl2Java.class$("org.apache.muse.tools.generator.projectizer.Projectizer")) : class$org$apache$muse$tools$generator$projectizer$Projectizer);
        }
        Object[] filler = new Object[]{"-help"};
        throw new MuseRuntimeException("InvalidArgs", _MESSAGES.get("InvalidArgs", filler));
    }

    private static Object loadClass(String className, Class targetInterface) {
        if (className == null) {
            return null;
        }
        Object result = null;
        Class<?> resultClass = null;
        try {
            resultClass = Class.forName(className);
            result = resultClass.newInstance();
        }
        catch (InstantiationException e) {
            Object[] filler = new Object[]{className};
            AbstractCommandLineApp.handleErrorAndExit(_MESSAGES.get("InstantiateFailed", filler), e);
        }
        catch (IllegalAccessException e) {
            Object[] filler = new Object[]{className};
            AbstractCommandLineApp.handleErrorAndExit(_MESSAGES.get("InstantiateFailed", filler), e);
        }
        catch (ClassNotFoundException e) {
            Object[] filler = new Object[]{className};
            AbstractCommandLineApp.handleErrorAndExit(_MESSAGES.get("ClassNotFound", filler), e);
        }
        if (!targetInterface.isAssignableFrom(resultClass)) {
            Object[] filler = new Object[]{className, targetInterface.getName()};
            AbstractCommandLineApp.handleErrorAndExit(_MESSAGES.get("DoesNotImplement", filler));
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

